/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.interpreters;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sikuli.slides.api.interpreters.Keyword;
import org.sikuli.slides.api.models.ImageElement;
import org.sikuli.slides.api.models.KeywordElement;
import org.sikuli.slides.api.models.Slide;
import org.sikuli.slides.api.models.SlideElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Selector {
    static Logger logger = LoggerFactory.getLogger(Selector.class);
    private Collection<SlideElement> elements;

    Selector(Collection<SlideElement> elements) {
        this.elements = elements;
    }

    public List<SlideElement> all() {
        return Lists.newArrayList(this.elements);
    }

    public SlideElement first() {
        if (this.elements.size() >= 1) {
            return this.elements.iterator().next();
        }
        return null;
    }

    public boolean exist() {
        return this.elements.size() > 0;
    }

    public static Selector select(Slide slide) {
        return new Selector(slide.getElements());
    }

    public static Selector select(Collection<SlideElement> elements) {
        return new Selector(elements);
    }

    public Selector intersects(final SlideElement element) {
        if (element == null) {
            this.elements = Lists.newArrayList();
            return this;
        }
        final Rectangle r = element.getBounds();
        this.elements = Collections2.filter(this.elements, new Predicate<SlideElement>(){

            @Override
            public boolean apply(SlideElement e) {
                return e != element && r.intersects(e.getBounds());
            }
        });
        return this;
    }

    public Selector near(final SlideElement element, int radius) {
        if (element == null) {
            this.elements = Lists.newArrayList();
            return this;
        }
        final Rectangle r = element.getBounds();
        r.x -= radius;
        r.y -= radius;
        r.width += 2 * radius;
        r.height += 2 * radius;
        this.elements = Collections2.filter(this.elements, new Predicate<SlideElement>(){

            @Override
            public boolean apply(SlideElement e) {
                return e != element && r.intersects(e.getBounds());
            }
        });
        return this;
    }

    public Selector hasText() {
        this.elements = Collections2.filter(this.elements, new Predicate<SlideElement>(){

            @Override
            public boolean apply(SlideElement e) {
                return Selector.hasText(e);
            }
        });
        return this;
    }

    public Selector hasNoText() {
        this.elements = Collections2.filter(this.elements, new Predicate<SlideElement>(){

            @Override
            public boolean apply(SlideElement e) {
                return !Selector.hasText(e);
            }
        });
        return this;
    }

    public static boolean hasText(SlideElement e) {
        return e.getText() != null && !e.getText().isEmpty();
    }

    public Selector isTarget() {
        final List<SlideElement> images = Selector.select(this.elements).isImage().all();
        this.elements = Collections2.filter(this.elements, new Predicate<SlideElement>(){

            @Override
            public boolean apply(SlideElement e) {
                return !Selector.hasText(e) && Selector.select(images).intersects(e).exist();
            }
        });
        return this;
    }

    public Selector isKeyword() {
        ArrayList<SlideElement> images = Lists.newArrayList();
        for (SlideElement e : this.elements) {
            if (!(e instanceof KeywordElement)) continue;
            images.add((KeywordElement)e);
        }
        this.elements = images;
        return this;
    }

    public Selector isKeyword(Keyword keyword) {
        ArrayList<SlideElement> newList = Lists.newArrayList();
        for (SlideElement e : this.elements) {
            if (!(e instanceof KeywordElement) || ((KeywordElement)e).getKeyword() != keyword) continue;
            newList.add((KeywordElement)e);
        }
        this.elements = newList;
        return this;
    }

    public Selector isImage() {
        ArrayList<SlideElement> images = Lists.newArrayList();
        for (SlideElement e : this.elements) {
            if (!(e instanceof ImageElement)) continue;
            images.add((ImageElement)e);
        }
        this.elements = images;
        return this;
    }

    public Selector isNotKeyword() {
        ArrayList<SlideElement> newList = Lists.newArrayList();
        for (SlideElement e : this.elements) {
            if (e instanceof KeywordElement) continue;
            newList.add(e);
        }
        this.elements = newList;
        return this;
    }
}

