/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.io;

import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PPTXBundle {
    static Logger logger = LoggerFactory.getLogger(PPTXBundle.class);
    private File rootDir;
    private String name = "";
    private int slideCount = 0;

    public String toString() {
        return Objects.toStringHelper(this).add("count", this.slideCount).add("rootDir", this.rootDir).toString();
    }

    public static PPTXBundle createFrom(File pptxFile) throws IOException {
        if (pptxFile == null || !pptxFile.exists()) {
            logger.error("File does not exist: {}", (Object)pptxFile);
            throw new IOException();
        }
        File workingDir = Files.createTempDir();
        if (workingDir == null) {
            logger.error("Failed to create sikuli-slides working directory in " + System.getProperty("java.io.tmpdir"));
            throw new IOException();
        }
        PPTXBundle bundle = new PPTXBundle(pptxFile, workingDir);
        if (!bundle.isValid()) {
            logger.error("File is not a valid pptx: {}", (Object)pptxFile);
            throw new IOException();
        }
        return bundle;
    }

    PPTXBundle(File pptxFile, File tmpDir) {
        this.name = pptxFile.getName();
        this.rootDir = new File(tmpDir, FilenameUtils.removeExtension(this.name));
        PPTXBundle.doUnZipFile(pptxFile, this.rootDir);
        if (this.isValid()) {
            this.slideCount = this.getSlidesDirectory().list().length - 1;
        }
    }

    boolean isValid() {
        return this.rootDir.exists() && this.getSlidesDirectory().exists() && this.getRelationshipsDirectory().exists();
    }

    int getSlideCount() {
        return this.slideCount;
    }

    File getRelationshipsDirectory() {
        return new File(this.rootDir, "ppt" + File.separator + "slides" + File.separator + "_rels");
    }

    File getSlidesDirectory() {
        return new File(this.rootDir, "ppt" + File.separator + "slides");
    }

    File getSlideXMLRel(int slideNumber) {
        String filename = String.format("slide%d.xml.rels", slideNumber);
        return new File(this.getRelationshipsDirectory(), filename);
    }

    File getSlideXML(int slideNumber) {
        String filename = String.format("slide%d.xml", slideNumber);
        return new File(this.getSlidesDirectory(), filename);
    }

    static void doUnZipFile(File file, File dest) {
        byte[] buffer = new byte[1024];
        try {
            File folder = dest;
            if (!folder.exists()) {
                folder.mkdir();
            } else {
                FileUtils.deleteDirectory(folder);
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file.getAbsoluteFile()));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(folder + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

