/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.io;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.sikuli.slides.api.io.PPTXBundle;
import org.sikuli.slides.api.io.SlidesReader;
import org.sikuli.slides.api.models.Slide;
import org.sikuli.slides.api.parsers.SlideParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PPTXSlidesReader
implements SlidesReader {
    static Logger logger = LoggerFactory.getLogger(PPTXSlidesReader.class);

    @Override
    public List<Slide> read(File pptxFile) throws IOException {
        PPTXBundle bundle = PPTXBundle.createFrom(pptxFile);
        logger.debug("PPTX bundle created: {}", (Object)bundle);
        SlideParser parser = new SlideParser();
        ArrayList<Slide> slides = Lists.newArrayList();
        int n = bundle.getSlideCount();
        for (int i = 1; i <= n; ++i) {
            Slide slide = parser.parse(bundle.getSlideXML(i), bundle.getSlideXMLRel(i));
            if (slide == null) continue;
            slide.setNumber(i);
            slides.add(slide);
            logger.debug("Slide {} of {} parsed: {}", i, n, slide);
        }
        return slides;
    }

    @Override
    public List<Slide> read(URL url) throws IOException {
        File pptxFile = null;
        if (url.getProtocol().toLowerCase().startsWith("http")) {
            url = PPTXSlidesReader.resolveDownloadURL(url);
            pptxFile = PPTXSlidesReader.downloadFile(url);
        } else if (url.getProtocol().compareToIgnoreCase("file") == 0) {
            pptxFile = new File(url.getFile());
        } else {
            throw new IOException("Unable to deal with " + url);
        }
        return this.read(pptxFile);
    }

    public static File downloadFile(URL downloadURL) {
        File destination;
        logger.info("Download file from {} ... ", (Object)downloadURL);
        try {
            String name = "download";
            destination = File.createTempFile(name, "");
            FileUtils.copyURLToFile(downloadURL, destination, 300000, 30000);
            logger.info("Download complete. Saved as {}", (Object)destination);
        }
        catch (IOException e) {
            logger.error("Unable to download {}", (Object)e.getMessage());
            destination = null;
        }
        return destination;
    }

    private static URL resolveDownloadURL(URL url) {
        block8: {
            if (url != null) {
                try {
                    String domainName;
                    URI uri = url.toURI();
                    String domain = uri.getHost();
                    if (domain == null) {
                        return null;
                    }
                    String string = domainName = domain.startsWith("www.") ? domain.substring(4) : domain;
                    if (domainName.equalsIgnoreCase("docs.google.com")) {
                        try {
                            String urlString = url.toString();
                            int startIndex = urlString.indexOf("/d/") + 3;
                            int lastIndex = urlString.indexOf("/edit");
                            String documentId = urlString.substring(startIndex, lastIndex);
                            String gDriveDownloadLink = "https://docs.google.com/presentation/d/" + documentId + "/export/pptx";
                            return new URL(gDriveDownloadLink);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            logger.error("ERROR: Invalid Google Drive link.");
                            break block8;
                        }
                    }
                    return url;
                }
                catch (URISyntaxException e) {
                    logger.error("ERROR: Invalid share link.");
                }
                catch (MalformedURLException e) {
                    logger.error("ERROR: Invalid share link.");
                }
            }
        }
        return null;
    }
}

