/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.models;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sikuli.slides.api.interpreters.Keyword;
import org.sikuli.slides.api.interpreters.Selector;
import org.sikuli.slides.api.models.ImageElement;
import org.sikuli.slides.api.models.KeywordElement;
import org.sikuli.slides.api.models.SlideElement;

public class Slide {
    List<SlideElement> elements = Lists.newArrayList();
    private int number;

    public Slide() {
    }

    public Slide(Slide slide) {
        this.elements = Lists.newArrayList(slide.elements);
        this.number = slide.number;
    }

    public void add(SlideElement element) {
        this.elements.add(element);
    }

    public void remove(SlideElement element) {
        this.elements.remove(element);
    }

    public Collection<SlideElement> getElements() {
        return Lists.newArrayList(this.elements);
    }

    public String toString() {
        ArrayList<String> elementNames = Lists.newArrayList();
        for (SlideElement el : this.elements) {
            elementNames.add(el.getClass().getSimpleName());
        }
        String txt = Joiner.on(";").join(elementNames);
        return Objects.toStringHelper(this).add("number", this.number).add("elements", txt).toString();
    }

    public Selector select() {
        return Selector.select(this);
    }

    public SlideElementBuilder newElement() {
        return new SlideElementBuilder(this);
    }

    public ImageElementBuilder newImageElement() {
        return new ImageElementBuilder(this);
    }

    public KeywordElementBuilder newKeywordElement() {
        return new KeywordElementBuilder(this);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public static class SlideElementBuilder {
        SlideElement element;
        protected Slide slide;

        SlideElementBuilder(Slide slide) {
            this.slide = slide;
            this.element = new SlideElement();
        }

        public SlideElementBuilder text(String text) {
            this.element.setText(text);
            return this;
        }

        public SlideElementBuilder bounds(int x, int y, int w, int h) {
            this.element.setOffx(x);
            this.element.setOffy(y);
            this.element.setCx(w);
            this.element.setCy(h);
            return this;
        }

        public SlideElement add() {
            this.slide.add(this.element);
            return this.element;
        }

        public SlideElementBuilder geom(String geom) {
            this.element.setGeom(geom);
            return this;
        }
    }

    public static class ImageElementBuilder
    extends SlideElementBuilder {
        ImageElementBuilder(Slide slide) {
            super(slide);
            this.element = new ImageElement();
        }

        public ImageElementBuilder source(URL source) {
            ((ImageElement)this.element).setSource(source);
            return this;
        }
    }

    public static class KeywordElementBuilder
    extends SlideElementBuilder {
        KeywordElementBuilder(Slide slide) {
            super(slide);
            this.element = new KeywordElement();
        }

        public KeywordElementBuilder keyword(Keyword keyword) {
            ((KeywordElement)this.element).setKeyword(keyword);
            return this;
        }
    }
}

