/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.parsers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sikuli.slides.api.interpreters.Keyword;
import org.sikuli.slides.api.interpreters.KeywordDictionary;
import org.sikuli.slides.api.models.ImageElement;
import org.sikuli.slides.api.models.KeywordElement;
import org.sikuli.slides.api.models.Slide;
import org.sikuli.slides.api.models.SlideElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SlideParser {
    static Map<String, String> parseRelationships(Document doc, File xml) {
        HashMap<String, String> ret = Maps.newHashMap();
        NodeList nodeList = doc.getElementsByTagName("Relationship");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element el = (Element)nodeList.item(i);
            String id = el.getAttribute("Id");
            String target = el.getAttribute("Target");
            String absoluteTarget = xml.getParent() + File.separator + target;
            ret.put(id, absoluteTarget);
        }
        return ret;
    }

    void parseSlideElement(Node node, SlideElement e) {
        if (node.getNodeType() == 1) {
            Element solidFill;
            Element srgbClr;
            NodeList list;
            Element rPr;
            Element txBodyElement;
            NodeList l;
            Element cNvPr;
            Element ext;
            Element element = (Element)node;
            Element spPr = (Element)element.getElementsByTagName("p:spPr").item(0);
            Element off = (Element)spPr.getElementsByTagName("a:off").item(0);
            if (off != null) {
                e.setOffx(Integer.parseInt(off.getAttribute("x")));
                e.setOffy(Integer.parseInt(off.getAttribute("y")));
            }
            if ((ext = (Element)spPr.getElementsByTagName("a:ext").item(0)) != null) {
                e.setCx(Integer.parseInt(ext.getAttribute("cx")));
                e.setCy(Integer.parseInt(ext.getAttribute("cy")));
            }
            if ((cNvPr = (Element)element.getElementsByTagName("p:cNvPr").item(0)) != null) {
                e.setName(cNvPr.getAttribute("name"));
                e.setId(cNvPr.getAttribute("id"));
            }
            String text = this.parseText(node);
            e.setText(text);
            NodeList txBodyList = element.getElementsByTagName("p:txBody");
            if (txBodyList.getLength() > 0 && (l = (txBodyElement = (Element)txBodyList.item(0)).getElementsByTagName("a:rPr")).getLength() > 0 && (rPr = (Element)l.item(0)).hasAttribute("sz")) {
                e.setTextSize(Integer.parseInt(rPr.getAttribute("sz")));
            }
            if ((list = element.getElementsByTagName("a:solidFill")).getLength() > 0 && (srgbClr = (Element)(solidFill = (Element)list.item(0)).getElementsByTagName("a:srgbClr").item(0)) != null) {
                e.setBackgroundColor(srgbClr.getAttribute("val"));
            }
            if ((list = element.getElementsByTagName("a:prstGeom")).getLength() > 0) {
                Element prstGeom = (Element)list.item(0);
                e.setGeom(prstGeom.getAttribute("prst"));
            }
        }
    }

    ImageElement parseImageElement(Node node, Map<String, String> map) {
        ImageElement e = new ImageElement();
        this.parseSlideElement(node, e);
        Element blip = (Element)((Element)node).getElementsByTagName("a:blip").item(0);
        String relationshipID = blip.getAttribute("r:embed");
        String target = map.get(relationshipID);
        e.setFileName(target);
        return e;
    }

    String parseParagraph(Node paragraphNode) {
        NodeList l = ((Element)paragraphNode).getElementsByTagName("a:t");
        String combinedText = "";
        for (int i = 0; i < l.getLength(); ++i) {
            combinedText = combinedText + l.item(i).getTextContent();
        }
        return combinedText;
    }

    String parseText(Node node) {
        Element element = (Element)node;
        NodeList txBodyList = element.getElementsByTagName("p:txBody");
        if (txBodyList.getLength() > 0) {
            Element txBodyElement = (Element)txBodyList.item(0);
            NodeList paragraphNodes = txBodyElement.getElementsByTagName("a:p");
            ArrayList<String> paras = Lists.newArrayList();
            for (int i = 0; i < paragraphNodes.getLength(); ++i) {
                paras.add(this.parseParagraph(paragraphNodes.item(i)));
            }
            return Joiner.on("\n").join(paras);
        }
        return null;
    }

    public KeywordElement parseKeywordElement(Node node) {
        String text = this.parseText(node);
        if (text == null) {
            return null;
        }
        Keyword keyword = KeywordDictionary.lookup(text);
        if (keyword == null) {
            return null;
        }
        KeywordElement keywordElement = new KeywordElement();
        keywordElement.setKeyword(keyword);
        this.parseSlideElement(node, keywordElement);
        String matchedPrefix = keyword.match(text);
        String rest = text.substring(matchedPrefix.length(), text.length());
        rest = rest.trim();
        keywordElement.setText(rest);
        return keywordElement;
    }

    public Slide parse(File xml, File rel) {
        Slide slide = new Slide();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        Document relDoc = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(xml.getPath());
            relDoc = dBuilder.parse(rel.getPath());
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
        if (doc == null) {
            return slide;
        }
        Map<String, String> map = SlideParser.parseRelationships(relDoc, xml);
        NodeList shapeNodeList = doc.getElementsByTagName("p:sp");
        for (int i = 0; i < shapeNodeList.getLength(); ++i) {
            Node nNode = shapeNodeList.item(i);
            SlideElement e = this.parseKeywordElement(nNode);
            if (e != null) {
                slide.add(e);
                continue;
            }
            if (((Element)nNode).getElementsByTagName("a:blip").getLength() > 0) {
                e = this.parseImageElement(nNode, map);
                slide.add(e);
                continue;
            }
            e = new SlideElement();
            this.parseSlideElement(nNode, e);
            slide.add(e);
        }
        NodeList picList = doc.getElementsByTagName("p:pic");
        for (int i = 0; i < picList.getLength(); ++i) {
            Node nNode = picList.item(i);
            ImageElement e = this.parseImageElement(nNode, map);
            slide.add(e);
        }
        return slide;
    }
}

