/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.sikuli;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.slides.api.sikuli.CrossSearchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextImageTarget
implements Target {
    static Logger logger = LoggerFactory.getLogger(ContextImageTarget.class);
    private URL contextImageURL;
    private BufferedImage contextImage;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private int limit = 1;
    private boolean isPixels = false;
    private int x;
    private int y;
    private int width;
    private int height;

    public ContextImageTarget(URL contextImageURL, double xmin, double ymin, double xmax, double ymax) {
        this.contextImageURL = contextImageURL;
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.isPixels = false;
    }

    public ContextImageTarget(URL contextImageURL, int x, int y, int width, int height) {
        this.contextImageURL = contextImageURL;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.isPixels = true;
    }

    @Override
    public double getMinScore() {
        return 0.0;
    }

    @Override
    public void setMinScore(double minScore) {
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public Target.Ordering getOrdering() {
        return null;
    }

    @Override
    public void setOrdering(Target.Ordering ordering) {
    }

    public Rectangle getTargetBounds() {
        BufferedImage image = this.getContextImage();
        Rectangle r = new Rectangle();
        if (this.isPixels) {
            r.x = Math.max(0, this.x);
            r.y = Math.max(0, this.y);
            r.width = Math.min(this.width + this.x, image.getWidth()) - this.x;
            r.height = Math.min(this.height + this.y, image.getHeight()) - this.y;
        } else {
            r.x = (int)Math.round(this.xmin * (double)image.getWidth());
            r.y = (int)Math.round(this.ymin * (double)image.getHeight());
            r.width = (int)((this.xmax - this.xmin) * (double)image.getWidth());
            r.height = (int)((this.ymax - this.ymin) * (double)image.getHeight());
        }
        return r;
    }

    public BufferedImage getTargetImage() {
        Rectangle bounds = this.getTargetBounds();
        BufferedImage image = this.getContextImage();
        return image.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public List<ScreenRegion> doFindAll(ScreenRegion screenRegion) {
        CrossSearchStrategy strategy = new CrossSearchStrategy(this.getContextImage(), this.getTargetBounds());
        ScreenRegion ret = strategy.perform(screenRegion);
        if (ret == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(ret);
    }

    public BufferedImage getContextImage() {
        if (this.contextImage == null) {
            try {
                this.contextImage = ImageIO.read(this.contextImageURL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.contextImage;
    }

    public String toString() {
        if (this.isPixels) {
            return Objects.toStringHelper(this).add("image", this.contextImageURL).add("x", this.x).add("y", this.y).add("width", this.width).add("height", this.height).toString();
        }
        return Objects.toStringHelper(this).add("image", this.contextImageURL).add("x", String.format("(%.2f,%.2f)", this.xmin, this.xmax)).add("y", String.format("(%.2f,%.2f)", this.ymin, this.ymax)).toString();
    }
}

