/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.sikuli;

import com.google.common.base.Objects;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.slides.api.sikuli.Hypothesis;

class ContextTargetHypothesis
implements Hypothesis {
    final BufferedImage contextImage;
    final Rectangle originalTargetRect;
    final Rectangle contextTargetRect;

    public ContextTargetHypothesis(BufferedImage contextImage, Rectangle originalTargetRect, Rectangle contextTargetRect) {
        this.contextImage = contextImage;
        this.originalTargetRect = originalTargetRect;
        this.contextTargetRect = contextTargetRect;
    }

    @Override
    public Target getTarget() {
        Rectangle r = this.contextTargetRect;
        BufferedImage targetImage = this.contextImage.getSubimage(r.x, r.y, r.width, r.height);
        ImageTarget target = new ImageTarget(targetImage);
        return target;
    }

    @Override
    public ScreenRegion interpretResult(ScreenRegion rawResult) {
        int xoffset = this.originalTargetRect.x - this.contextTargetRect.x;
        int yoffset = this.originalTargetRect.y - this.contextTargetRect.y;
        ScreenRegion finalResult = rawResult.getRelativeScreenRegion(xoffset, yoffset, this.originalTargetRect.width, this.originalTargetRect.height);
        return finalResult;
    }

    public String toString() {
        Rectangle r = this.contextTargetRect;
        return Objects.toStringHelper(this).add("rect", String.format("%d,%d,%d,%d", r.x, r.y, r.width, r.height)).toString();
    }
}

