/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.sikuli;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.slides.api.sikuli.ContextTargetHypothesis;
import org.sikuli.slides.api.sikuli.Hypothesis;
import org.sikuli.slides.api.sikuli.SearchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSearchStrategy
implements SearchStrategy {
    private static final Logger logger = LoggerFactory.getLogger(CrossSearchStrategy.class);
    private static final int widthFactor = 30;
    private static final int heightFactor = 30;
    BufferedImage contextImage;
    Rectangle targetRect;

    public CrossSearchStrategy(BufferedImage contextImage, Rectangle targetRect) {
        this.contextImage = contextImage;
        this.targetRect = targetRect;
    }

    @Override
    public ScreenRegion perform(ScreenRegion screenRegion) {
        List<Hypothesis> hs = CrossSearchStrategy.generateHypotheses(this.contextImage, this.targetRect);
        logger.debug("generated {} hypotheses", (Object)hs.size());
        ScreenRegion ret = CrossSearchStrategy.testHypotheses(screenRegion, hs);
        return ret;
    }

    private static List<Hypothesis> generateHypotheses(BufferedImage contextImage, Rectangle targetRect) {
        Rectangle bounds = new Rectangle(0, 0, contextImage.getWidth(), contextImage.getHeight());
        List<Rectangle> regions = CrossSearchStrategy.generateLargerRegions(targetRect, bounds);
        CrossSearchStrategy.sortBySize(regions);
        ArrayList<Hypothesis> hs = Lists.newArrayList();
        for (Rectangle r : regions) {
            ContextTargetHypothesis h = new ContextTargetHypothesis(contextImage, targetRect, r);
            hs.add(h);
        }
        return hs;
    }

    public static List<Rectangle> generateLargerRegions(Rectangle seed, Rectangle bounds) {
        ArrayList<Rectangle> result = Lists.newArrayList();
        result.add(seed);
        result.addAll(CrossSearchStrategy.generateLargerRegionsAbove(seed, bounds));
        result.addAll(CrossSearchStrategy.generateLargerRegionsBelow(seed, bounds));
        result.addAll(CrossSearchStrategy.generateLargerRegionsLeft(seed, bounds));
        result.addAll(CrossSearchStrategy.generateLargerRegionsRight(seed, bounds));
        return result;
    }

    public static List<Rectangle> sortBySize(List<Rectangle> list) {
        ArrayList<Rectangle> result = Lists.newArrayList();
        Collections.sort(list, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle r1, Rectangle r2) {
                return r1.height * r1.width - r2.height * r2.width;
            }
        });
        return result;
    }

    private static ScreenRegion testHypotheses(ScreenRegion screenRegion, List<Hypothesis> hypotheses) {
        for (Hypothesis hypothesis : hypotheses) {
            Target target = hypothesis.getTarget();
            List<ScreenRegion> lookupRegion = screenRegion.findAll(target);
            logger.debug("test: {} ... found {} matches", (Object)hypothesis, (Object)lookupRegion.size());
            if (lookupRegion.size() > 1) continue;
            if (lookupRegion.size() == 1) {
                ScreenRegion rawResult = lookupRegion.get(0);
                return hypothesis.interpretResult(rawResult);
            }
            return null;
        }
        return null;
    }

    public static List<Rectangle> generateLargerRegionsAbove(Rectangle seed, Rectangle bounds) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        Rectangle r = new Rectangle(seed);
        for (int i = 0; i < 20; ++i) {
            r.y -= 30;
            r.height += 30;
            r = bounds.intersection(r);
            result.add(new Rectangle(r));
            if (r.y <= bounds.y) break;
        }
        return result;
    }

    public static List<Rectangle> generateLargerRegionsBelow(Rectangle seed, Rectangle bounds) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        Rectangle r = new Rectangle(seed);
        for (int i = 0; i < 20; ++i) {
            r.height += 30;
            r = bounds.intersection(r);
            result.add(new Rectangle(r));
            if (r.y + r.height >= bounds.y + bounds.height) break;
        }
        return result;
    }

    public static List<Rectangle> generateLargerRegionsRight(Rectangle seed, Rectangle bounds) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        Rectangle r = new Rectangle(seed);
        for (int i = 0; i < 20; ++i) {
            r.width += 30;
            r = bounds.intersection(r);
            result.add(new Rectangle(r));
            if (r.x + r.width >= bounds.x + bounds.width) break;
        }
        return result;
    }

    public static List<Rectangle> generateLargerRegionsLeft(Rectangle seed, Rectangle bounds) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        Rectangle r = new Rectangle(seed);
        for (int i = 0; i < 20; ++i) {
            r.x -= 30;
            r.width += 30;
            r = bounds.intersection(r);
            result.add(new Rectangle(r));
            if (r.x <= bounds.x) break;
        }
        return result;
    }
}

