/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.core;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.sikuli.slides.v1.core.SikuliAction;
import org.sikuli.slides.v1.media.Sound;
import org.sikuli.slides.v1.parsing.PresentationParser;
import org.sikuli.slides.v1.parsing.SlideParser;
import org.sikuli.slides.v1.presentation.Presentation;
import org.sikuli.slides.v1.processing.ImageProcessing;
import org.sikuli.slides.v1.processing.Relationship;
import org.sikuli.slides.v1.processing.SlideProcessing;
import org.sikuli.slides.v1.screenshots.Screenshot;
import org.sikuli.slides.v1.screenshots.SlideTargetRegion;
import org.sikuli.slides.v1.shapes.SlideShape;
import org.sikuli.slides.v1.utils.Constants;
import org.sikuli.slides.v1.utils.UnitConverter;
import org.sikuli.slides.v1.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SikuliPowerPoint {
    private static final Logger logger = LoggerFactory.getLogger(SikuliPowerPoint.class);
    private Presentation presentation;
    private String pptxSourceName;
    private AtomicInteger counter;
    private List<SikuliAction> tasks;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public SikuliPowerPoint(String pptxSourceName) {
        this.pptxSourceName = pptxSourceName;
        this.counter = new AtomicInteger();
        this.tasks = new ArrayList<SikuliAction>();
    }

    public void runSikuliPowerPoint(int start, int end) {
        this.loadPresentationFile();
        this.parsePresentationFile();
        if (end == -1) {
            end = this.presentation.getSlidesCount();
        }
        for (int i = start; i <= end; ++i) {
            this.parseSlideFile(i);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SikuliPowerPoint.this.executeSikuliActions();
            }
        }).start();
    }

    public void runSikuliPowerPoint() {
        this.runSikuliPowerPoint(1, this.presentation.getSlidesCount());
    }

    private void loadPresentationFile() {
        File file = null;
        file = this.pptxSourceName.startsWith("http") ? Utils.downloadFile(this.pptxSourceName) : new File(this.pptxSourceName);
        if (file != null) {
            Constants.projectDirectory = Constants.workingDirectoryPath + File.separator + FilenameUtils.removeExtension(file.getName());
            Utils.doZipFile(file);
            Utils.doUnZipFile(file);
            Utils.createSikuliImagesDirectory();
        } else {
            logger.error("ERROR: Failed to find the .pptx file");
            System.exit(0);
        }
    }

    private void parsePresentationFile() {
        PresentationParser presentationParser = new PresentationParser();
        presentationParser.parseDocument();
        this.presentation = presentationParser.getPresentation();
    }

    private void parseSlideFile(int slideNumber) {
        String slidesDirectory = Constants.projectDirectory + Constants.SLIDES_DIRECTORY;
        String slideName = File.separator + "slide" + Integer.toString(slideNumber) + ".xml";
        String slidePath = slidesDirectory + slideName;
        logger.info("Processing slide: " + slideNumber);
        SlideParser mySlideParser = new SlideParser(slidePath);
        mySlideParser.parseDocument();
        Screenshot screenshot = mySlideParser.getScreenshot();
        List<SlideShape> slideShapes = mySlideParser.getShapes();
        Sound sound = mySlideParser.getSound();
        if (sound != null) {
            this.setSoundFileName(sound, slideName);
        }
        List<SlideShape> labels = mySlideParser.getLabels();
        SlideShape label = null;
        if (labels != null && labels.size() > 0) {
            label = labels.get(0);
        }
        Constants.DesktopEvent desktopEvent = null;
        List<SlideShape> targetShapes = null;
        if (Constants.UseOldSyntax) {
            if (slideShapes == null || slideShapes.size() == 0) {
                logger.error("Failed to process slide {}. The slide must contain a predefined shape.", (Object)slideNumber);
                System.exit(1);
            } else {
                desktopEvent = this.getOldDesktopEvent(slideShapes);
                if (desktopEvent == null) {
                    if (slideShapes.size() == 1) {
                        logger.error("Failed to process slide {}. The slide must contain a predefined shape.", (Object)slideNumber);
                    } else {
                        logger.error("Error: Slide {}. Multiple targets are not supported in the old syntax.{}. Use the default new syntax option to enable multiple targets per slide.", (Object)slideNumber, (Object)NEW_LINE);
                    }
                    System.exit(1);
                }
                if (slideShapes.size() == 1) {
                    targetShapes = new ArrayList<SlideShape>();
                    targetShapes.add(slideShapes.get(0));
                } else if (slideShapes.size() == 2 && desktopEvent == Constants.DesktopEvent.DRAG_N_DROP) {
                    targetShapes = new ArrayList<SlideShape>();
                    targetShapes.add(slideShapes.get(0));
                    targetShapes.add(slideShapes.get(1));
                } else {
                    logger.error("Error. Slide {} contains multiple shapes.{}The slide must contain only one input action using the predefined shapes.{}You may use the new syntax to enable multiple targets per slide.", slideNumber, NEW_LINE, NEW_LINE);
                    System.exit(1);
                }
            }
        } else if (!Constants.UseOldSyntax) {
            desktopEvent = this.getDesktopEvent(slideShapes);
            targetShapes = this.getTargterShapes(slideShapes);
            if (labels == null && desktopEvent == null && sound == null || slideShapes == null) {
                logger.error("Failed to process slide {}.The slide must contain a shape and textbox that contains the action to be executed.{}The text box that descripes the action must contain one of the following actions:{}Click, Right Click, Double Click, Type, Drag, Browser, Exist, Not Exist, Wait", slideNumber, NEW_LINE, NEW_LINE);
                return;
            }
        }
        if (desktopEvent == Constants.DesktopEvent.LAUNCH_BROWSER) {
            this.tasks.add(new SikuliAction(null, targetShapes.get(0), screenshot, null, desktopEvent, sound, label, null, null));
            return;
        }
        if (desktopEvent == Constants.DesktopEvent.WAIT) {
            this.tasks.add(new SikuliAction(null, targetShapes.get(0), screenshot, null, desktopEvent, sound, label, null, null));
            return;
        }
        if (desktopEvent == null && sound != null) {
            this.tasks.add(new SikuliAction(null, new SlideShape(), null, null, null, sound, null, null, null));
            return;
        }
        if (screenshot == null) {
            logger.info("Error in slide {}.", (Object)slideNumber);
            return;
        }
        this.setScreenshotFileName(screenshot, slideName);
        if (desktopEvent == null && label != null) {
            this.startProcessing(screenshot, label, desktopEvent, slideNumber, sound, label);
        }
        for (SlideShape slideShape : targetShapes) {
            this.startProcessing(screenshot, slideShape, desktopEvent, slideNumber, sound, label);
        }
    }

    private List<SlideShape> getTargterShapes(List<SlideShape> slideShapes) {
        ArrayList<SlideShape> targetShapes = new ArrayList<SlideShape>();
        for (SlideShape slideShape : slideShapes) {
            if (slideShape.getType().equals("rect") && slideShape.getName().contains("TextBox")) continue;
            targetShapes.add(slideShape);
        }
        return targetShapes;
    }

    private Constants.DesktopEvent getDesktopEvent(List<SlideShape> slideShapes) {
        Constants.DesktopEvent desktopEvent = null;
        for (SlideShape slideShape : slideShapes) {
            if (!slideShape.getType().equals("rect")) continue;
            String action = slideShape.getText().trim();
            if (action.equalsIgnoreCase("Click") || action.equalsIgnoreCase("Left Click")) {
                desktopEvent = Constants.DesktopEvent.LEFT_CLICK;
                slideShapes.remove(slideShape);
                break;
            }
            if (action.equalsIgnoreCase("Right Click")) {
                desktopEvent = Constants.DesktopEvent.RIGHT_CLICK;
                slideShapes.remove(slideShape);
                break;
            }
            if (action.equalsIgnoreCase("Double Click")) {
                desktopEvent = Constants.DesktopEvent.DOUBLE_CLICK;
                slideShapes.remove(slideShape);
                break;
            }
            if (action.equalsIgnoreCase("Type")) {
                desktopEvent = Constants.DesktopEvent.KEYBOARD_TYPING;
                slideShapes.remove(slideShape);
                break;
            }
            if (action.toLowerCase().contains("drag") || action.toLowerCase().contains("drop")) {
                desktopEvent = Constants.DesktopEvent.DRAG_N_DROP;
                slideShapes.remove(slideShape);
                break;
            }
            if (action.toLowerCase().contains("browser")) {
                desktopEvent = Constants.DesktopEvent.LAUNCH_BROWSER;
                slideShapes.remove(slideShape);
                break;
            }
            if (action.toLowerCase().contains("not exist")) {
                desktopEvent = Constants.DesktopEvent.NOT_EXIST;
                slideShapes.remove(slideShape);
                break;
            }
            if (action.toLowerCase().contains("exist")) {
                desktopEvent = Constants.DesktopEvent.EXIST;
                slideShapes.remove(slideShape);
                break;
            }
            if (!action.equalsIgnoreCase("wait") && !action.equalsIgnoreCase("delay")) continue;
            desktopEvent = Constants.DesktopEvent.WAIT;
            slideShapes.remove(slideShape);
            break;
        }
        return desktopEvent;
    }

    private Constants.DesktopEvent getOldDesktopEvent(List<SlideShape> slideShapes) {
        String shapeType = slideShapes.get(0).getType();
        String shapeName = slideShapes.get(0).getName();
        if (slideShapes.size() == 2) {
            if (shapeType.equals("roundRect") && shapeName.contains("Rounded Rectangle")) {
                return Constants.DesktopEvent.DRAG_N_DROP;
            }
        } else {
            if (shapeType.equals("rect") && shapeName.contains("Rectangle")) {
                return Constants.DesktopEvent.LEFT_CLICK;
            }
            if (shapeType.equals("frame") && shapeName.contains("Frame")) {
                return Constants.DesktopEvent.DOUBLE_CLICK;
            }
            if (shapeType.equals("ellipse") && shapeName.contains("Oval")) {
                return Constants.DesktopEvent.RIGHT_CLICK;
            }
            if (shapeType.equals("cloud") && shapeName.contains("Cloud")) {
                return Constants.DesktopEvent.LAUNCH_BROWSER;
            }
            if (shapeType.equals("rect") && shapeName.contains("TextBox")) {
                return Constants.DesktopEvent.KEYBOARD_TYPING;
            }
        }
        return null;
    }

    private void setScreenshotFileName(Screenshot screenshot, String slideName) {
        Relationship relationship = new Relationship(slideName);
        screenshot.setFileName(relationship.getMediaFileName(screenshot.getRelationshipID()));
    }

    private void setSoundFileName(Sound sound, String slideName) {
        Relationship relationship = new Relationship(slideName);
        sound.setFileName(relationship.getMediaFileName(sound.getRelationshipId()));
    }

    private void startProcessing(Screenshot screenshot, SlideShape slideShape, Constants.DesktopEvent desktopEvent, int slideNumber, Sound sound, SlideShape slideLabel) {
        SlideTargetRegionContainer slideTarget = this.getSlideShapeRegion(screenshot, slideShape, slideNumber);
        File targetFile = slideTarget.getSlideTargetFile();
        SlideTargetRegion slideTargetRegion = slideTarget.getSlideTargetRegion();
        File labelTargetFile = null;
        SlideTargetRegion slideLabelTargetRegion = null;
        if (slideLabel != null) {
            SlideTargetRegionContainer slideLabelTarget = this.getSlideShapeRegion(screenshot, slideLabel, slideNumber);
            labelTargetFile = slideLabelTarget.getSlideTargetFile();
            slideLabelTargetRegion = slideLabelTarget.getSlideTargetRegion();
        }
        this.tasks.add(new SikuliAction(targetFile, slideShape, screenshot, slideTargetRegion, desktopEvent, sound, slideLabel, labelTargetFile, slideLabelTargetRegion));
    }

    private SlideTargetRegionContainer getSlideShapeRegion(Screenshot screenshot, SlideShape slideShape, int slideNumber) {
        String slideMediaLocation = Constants.projectDirectory + Constants.MEDIA_DIRECTORY + File.separator + screenshot.getFileName();
        SlideProcessing slideProcessing = new SlideProcessing(slideMediaLocation);
        int resizedScreenshotWidth = UnitConverter.emuToPixels(screenshot.getCx());
        int resizedScreenshotHeight = UnitConverter.emuToPixels(screenshot.getCy());
        int relativeRectangleWidth = (int)Math.round(ImageProcessing.scaleRectangleWidth(UnitConverter.emuToPixels(slideShape.getCx()), resizedScreenshotWidth, slideProcessing.getScreenshotWidth()));
        int relativeRectangleHeight = (int)Math.round(ImageProcessing.scaleRectangleHeight(UnitConverter.emuToPixels(slideShape.getCy()), resizedScreenshotHeight, slideProcessing.getScreenshotHeight()));
        int diffX = slideShape.getOffx() - screenshot.getOffX();
        int diffY = slideShape.getOffy() - screenshot.getOffY();
        int relativeRectangleX = (int)Math.round(ImageProcessing.getRelativeX(UnitConverter.emuToPixels(diffX), resizedScreenshotWidth, slideProcessing.getScreenshotWidth()));
        int relativeRectangleY = (int)Math.round(ImageProcessing.getRelativeY(UnitConverter.emuToPixels(diffY), resizedScreenshotHeight, slideProcessing.getScreenshotHeight()));
        SlideTargetRegion slideTargetRegion = new SlideTargetRegion("", slideNumber, slideMediaLocation, relativeRectangleX, relativeRectangleY, relativeRectangleWidth, relativeRectangleHeight, slideProcessing.getScreenshotWidth(), slideProcessing.getScreenshotHeight());
        File targetRegionFile = this.saveTargetImage(slideMediaLocation, relativeRectangleX, relativeRectangleY, relativeRectangleWidth, relativeRectangleHeight);
        return new SlideTargetRegionContainer(slideTargetRegion, targetRegionFile);
    }

    private File saveTargetImage(String slideMediaLocation, int relativeRectangleX, int relativeRectangleY, int relativeRectangleWidth, int relativeRectangleHeight) {
        BufferedImage croppedImage = ImageProcessing.cropImage(slideMediaLocation, Math.round(relativeRectangleX), Math.round(relativeRectangleY), Math.round(relativeRectangleWidth), Math.round(relativeRectangleHeight));
        String croppedImageName = Constants.projectDirectory + Constants.SIKULI_DIRECTORY + Constants.IMAGES_DIRECTORY + File.separator + "target" + Integer.toString(this.counter.incrementAndGet()) + ".png";
        ImageProcessing.writeImageToDisk(croppedImage, croppedImageName);
        return new File(croppedImageName);
    }

    private void executeSikuliActions() {
        if (Constants.TUTORIAL_MODE) {
            logger.info("Running in tutorial mode...");
        } else {
            for (SikuliAction sikuliAction : this.tasks) {
                sikuliAction.doSikuliAction();
            }
        }
        this.printExecutionTime();
    }

    private void printExecutionTime() {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - Constants.Execution_Start_Time;
        long hr = TimeUnit.MILLISECONDS.toHours(elapsedTime);
        long min = TimeUnit.MILLISECONDS.toMinutes(elapsedTime - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(elapsedTime - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        long ms = TimeUnit.MILLISECONDS.toMillis(elapsedTime - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec));
        String formattedTime = String.format("%02d:%02d:%02d.%02d", hr, min, sec, ms);
        logger.info("Finished after " + formattedTime);
    }

    class SlideTargetRegionContainer {
        private SlideTargetRegion slideTargetRegion;
        private File slideTargetFile;

        public SlideTargetRegionContainer(SlideTargetRegion slideTargetRegion, File slideTargetFile) {
            this.slideTargetRegion = slideTargetRegion;
            this.slideTargetFile = slideTargetFile;
        }

        public SlideTargetRegion getSlideTargetRegion() {
            return this.slideTargetRegion;
        }

        public File getSlideTargetFile() {
            return this.slideTargetFile;
        }
    }
}

