/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.listeners;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;
import org.sikuli.api.ScreenRegion;
import org.sikuli.slides.v1.utils.Constants;

public class GlobalKeyboardListeners
implements NativeKeyListener,
Runnable {
    private ScreenRegion region;
    private String textToBeTyped;
    private Constants.DesktopEvent desktopEvent;
    private AtomicBoolean isPerformed;
    private StringBuilder typedText;

    public GlobalKeyboardListeners(ScreenRegion region, String textToBeTyped, Constants.DesktopEvent desktopEvent) {
        this.region = region;
        this.textToBeTyped = textToBeTyped.replaceAll("\\s", "");
        this.desktopEvent = desktopEvent;
        this.isPerformed = new AtomicBoolean();
        this.typedText = new StringBuilder();
    }

    @Override
    public void nativeKeyPressed(NativeKeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.isPerformed.set(true);
        }
    }

    @Override
    public void nativeKeyReleased(NativeKeyEvent e) {
    }

    @Override
    public void nativeKeyTyped(NativeKeyEvent e) {
        char ch = e.getKeyChar();
        if (Character.isLetter(ch)) {
            this.typedText.append(ch);
            if (this.textToBeTyped.equalsIgnoreCase(this.typedText.toString())) {
                this.isPerformed.set(true);
            }
        }
    }

    @Override
    public void run() {
        while (!this.isPerformed.get()) {
            try {
                Thread.sleep(100L);
                if (Constants.IsPreviousStep) {
                    Constants.IsPreviousStep = false;
                    break;
                }
                if (!Constants.IsNextStep) continue;
                Constants.IsNextStep = false;
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

