/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.listeners;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jnativehook.mouse.NativeMouseEvent;
import org.jnativehook.mouse.NativeMouseInputListener;
import org.sikuli.api.ScreenRegion;
import org.sikuli.slides.v1.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMouseListeners
implements NativeMouseInputListener,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(GlobalMouseListeners.class);
    private AtomicBoolean isPerformed;
    private ScreenRegion region;
    private Constants.DesktopEvent desktopEvent;
    private static AtomicBoolean isDragged = new AtomicBoolean();

    public GlobalMouseListeners(ScreenRegion region, Constants.DesktopEvent desktopEvent) {
        this.region = region;
        this.desktopEvent = desktopEvent;
        this.isPerformed = new AtomicBoolean();
    }

    @Override
    public void nativeMouseClicked(NativeMouseEvent e) {
        if (this.desktopEvent == Constants.DesktopEvent.DOUBLE_CLICK && e.getClickCount() == 2) {
            if (this.inRange(e)) {
                logger.info("Double click action was successfully performed.");
                logger.info("========================================");
                this.isPerformed.set(true);
            } else {
                this.handleClickError();
            }
        } else if (this.desktopEvent == Constants.DesktopEvent.LEFT_CLICK) {
            if (this.inRange(e)) {
                logger.info("Click action was successfully performed.");
                logger.info("========================================");
                this.isPerformed.set(true);
            } else {
                this.handleClickError();
            }
        } else if (this.desktopEvent == Constants.DesktopEvent.RIGHT_CLICK && e.getButton() == 2) {
            if (this.inRange(e)) {
                logger.info("Right click action was successfully performed.");
                logger.info("========================================");
                this.isPerformed.set(true);
            } else {
                this.handleClickError();
            }
        }
    }

    private boolean inRange(NativeMouseEvent e) {
        int x_val = (int)this.region.getBounds().getX() + Constants.Total_Screen_Width;
        int y_val = (int)this.region.getBounds().getY();
        int max_x = this.region.getBounds().width + x_val;
        int max_y = this.region.getBounds().height + y_val;
        int clicked_x = e.getX();
        int clicked_y = e.getY();
        return clicked_x >= x_val && clicked_x <= max_x && clicked_y >= y_val && clicked_y <= max_y;
    }

    @Override
    public void nativeMousePressed(NativeMouseEvent e) {
        if (this.desktopEvent == Constants.DesktopEvent.DRAG_N_DROP) {
            if (this.inRange(e)) {
                isDragged.set(true);
                logger.info("Interacting with drag target...");
                this.isPerformed.set(true);
            } else {
                this.handleClickError();
            }
        }
    }

    @Override
    public void nativeMouseReleased(NativeMouseEvent e) {
        if (this.desktopEvent == Constants.DesktopEvent.DRAG_N_DROP && isDragged.get()) {
            if (this.inRange(e)) {
                logger.info("Drag and drop action was successfully performed.");
                logger.info("========================================");
                this.isPerformed.set(true);
            } else {
                this.handleClickError();
            }
        }
    }

    @Override
    public void nativeMouseDragged(NativeMouseEvent e) {
    }

    @Override
    public void nativeMouseMoved(NativeMouseEvent e) {
    }

    private void handleClickError() {
        logger.info("Error: Please click inside the heighlighted rectangle.");
    }

    @Override
    public void run() {
        while (!this.isPerformed.get()) {
            try {
                Thread.sleep(100L);
                if (Constants.IsPreviousStep) {
                    Constants.IsPreviousStep = false;
                    break;
                }
                if (!Constants.IsNextStep) continue;
                Constants.IsNextStep = false;
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

