/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.parsing;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sikuli.slides.v1.presentation.Presentation;
import org.sikuli.slides.v1.utils.Constants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PresentationParser
extends DefaultHandler {
    private String xmlFile = Constants.projectDirectory + Constants.PRESENTATION_DIRECTORY;
    private Presentation presentation = new Presentation();
    private int slidesCount = 0;
    private boolean inSlideIdList = false;

    public void parseDocument() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.xmlFile, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("p:sldIdLst")) {
            this.inSlideIdList = true;
        } else if (qName.equalsIgnoreCase("p:sldId")) {
            ++this.slidesCount;
        } else if (qName.equalsIgnoreCase("p:sldSz")) {
            this.presentation.setCX(Integer.parseInt(attributes.getValue("cx")));
            this.presentation.setCY(Integer.parseInt(attributes.getValue("cy")));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inSlideIdList && qName.equalsIgnoreCase("p:sldIdLst")) {
            this.inSlideIdList = false;
            this.presentation.setSlidesCount(this.slidesCount);
        }
    }

    public Presentation getPresentation() {
        return this.presentation;
    }
}

