/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sikuli.slides.v1.media.Sound;
import org.sikuli.slides.v1.screenshots.Screenshot;
import org.sikuli.slides.v1.shapes.SlideShape;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SlideParser
extends DefaultHandler {
    private Screenshot originalScreenshot;
    private Sound mSound;
    private String xmlFile;
    private boolean inScreenshot = false;
    private boolean inPictureElement = false;
    private boolean inSound = false;
    private boolean inShapeProperties = false;
    private boolean inShapeBackgroundColor = false;
    private boolean inShapeLineProperties = false;
    private boolean inShape = false;
    private boolean inArrowShape = false;
    private SlideShape slideShape;
    private boolean isSortedTargets = false;
    private boolean inTextBody = false;
    private String textBody = "";
    private String arrowHeadId = "";
    private String arrowEndId = "";
    private List<SlideShape> shapesList;
    private List<SlideShape> labelsList;
    private int order;
    private String _shapeName;
    private String _shapeId;
    private int _offx;
    private int _offy;
    private int _cx;
    private int _cy;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public SlideParser(String xmlFile) {
        this.xmlFile = xmlFile;
        this.shapesList = new ArrayList<SlideShape>();
        this.labelsList = new ArrayList<SlideShape>();
    }

    public void parseDocument() {
        this.textBody = "";
        this.arrowHeadId = "";
        this.arrowEndId = "";
        this.order = -1;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.xmlFile, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("p:pic")) {
            this.inPictureElement = true;
        } else if (this.inScreenshot && qName.equalsIgnoreCase("a:blip")) {
            this.originalScreenshot.setRelationshipID(attributes.getValue("r:embed"));
        } else if (this.inSound && qName.equalsIgnoreCase("a:audioFile")) {
            this.mSound.setRelationshipId(attributes.getValue("r:link"));
        } else if (this.inPictureElement && qName.equalsIgnoreCase("p:cNvPr")) {
            String name = attributes.getValue("name");
            if (name.contains("Picture")) {
                this.originalScreenshot = new Screenshot();
                this.inScreenshot = true;
                this.originalScreenshot.setName(name);
            } else if (name.contains("Sound") || name.contains(".wav") || name.contains(".mp3") || name.contains(".aiff") || name.contains(".au")) {
                this.mSound = new Sound();
                this.inSound = true;
                this.mSound.setName(name);
            }
        } else if (this.inScreenshot && qName.equals("p:spPr")) {
            this.inShapeProperties = true;
        } else if (this.inScreenshot && this.inShapeProperties && qName.equalsIgnoreCase("a:off")) {
            this.originalScreenshot.setOffX(Integer.parseInt(attributes.getValue("x")));
            this.originalScreenshot.setOffY(Integer.parseInt(attributes.getValue("y")));
        } else if (this.inScreenshot && this.inShapeProperties && qName.equalsIgnoreCase("a:ext")) {
            String cx_val = attributes.getValue("cx");
            String cy_val = attributes.getValue("cy");
            if (cx_val != null && cy_val != null) {
                this.originalScreenshot.setCx(Integer.parseInt(attributes.getValue("cx")));
                this.originalScreenshot.setCy(Integer.parseInt(attributes.getValue("cy")));
            }
        } else if (qName.equalsIgnoreCase("p:sp")) {
            this.inShape = true;
            ++this.order;
            this._shapeName = "";
            this._shapeId = "";
            this._offx = 0;
            this._offy = 0;
            this._cx = 0;
            this._cy = 0;
        } else if (this.inShape && qName.equalsIgnoreCase("p:cNvPr")) {
            this._shapeName = attributes.getValue("name");
            this._shapeId = attributes.getValue("id");
        } else if (this.inShape && qName.equalsIgnoreCase("a:off")) {
            this._offx = Integer.parseInt(attributes.getValue("x"));
            this._offy = Integer.parseInt(attributes.getValue("y"));
        } else if (this.inShape && qName.equalsIgnoreCase("a:ext")) {
            this._cx = Integer.parseInt(attributes.getValue("cx"));
            this._cy = Integer.parseInt(attributes.getValue("cy"));
        } else if (this.inShape && qName.equalsIgnoreCase("a:prstGeom")) {
            String shapeType = attributes.getValue("prst");
            this.slideShape = new SlideShape(this._shapeId, this._shapeName, this.order, shapeType, this._offx, this._offy, this._cx, this._cy, "", 0, "");
        } else if (this.inShape && qName.equalsIgnoreCase("a:solidFill")) {
            this.inShapeBackgroundColor = true;
        } else if (this.inShape && this.inShapeBackgroundColor && !this.inShapeLineProperties && qName.equalsIgnoreCase("a:srgbClr")) {
            if (this.slideShape != null) {
                this.slideShape.setBackgroundColor(attributes.getValue("val"));
            }
        } else if (this.inShape && qName.equalsIgnoreCase("a:ln")) {
            this.inShapeLineProperties = true;
            if (this.slideShape != null) {
                String lineWidthValue = attributes.getValue("w");
                int lineWidth = 0;
                try {
                    lineWidth = Integer.parseInt(lineWidthValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.slideShape.setLineWidth(lineWidth);
            }
        } else if (this.inShape && this.inShapeLineProperties && qName.equalsIgnoreCase("a:srgbClr")) {
            if (this.slideShape != null) {
                String lineColorValue = attributes.getValue("val");
                String lineColor = lineColorValue == null ? "" : lineColorValue;
                this.slideShape.setLineColor(lineColor);
            }
        } else if (this.inShape && qName.equalsIgnoreCase("p:txBody")) {
            this.inTextBody = true;
        } else if (this.inShape && qName.equalsIgnoreCase("a:blip")) {
            this.inShape = false;
            this.originalScreenshot = new Screenshot();
            this.originalScreenshot.setName(this.slideShape.getName());
            this.originalScreenshot.setCx(this.slideShape.getCx());
            this.originalScreenshot.setCy(this.slideShape.getCy());
            this.originalScreenshot.setOffX(this.slideShape.getOffx());
            this.originalScreenshot.setOffY(this.slideShape.getOffy());
            this.originalScreenshot.setRelationshipID(attributes.getValue("r:embed"));
            this.inScreenshot = true;
        } else if (this.inTextBody && qName.equals("a:rPr")) {
            String size = attributes.getValue("sz");
            if (size != null && this.slideShape != null) {
                this.slideShape.setTextSize(Integer.parseInt(size));
            }
        } else if (qName.equalsIgnoreCase("p:cxnSp")) {
            this.inArrowShape = true;
        } else if (this.inArrowShape && qName.equalsIgnoreCase("a:stCxn")) {
            this.arrowHeadId = attributes.getValue("id");
        } else if (this.inArrowShape && qName.equalsIgnoreCase("a:endCxn")) {
            this.arrowEndId = attributes.getValue("id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inScreenshot && qName.equalsIgnoreCase("p:pic")) {
            if (this.inScreenshot) {
                this.inScreenshot = false;
            } else if (this.inSound) {
                this.inSound = false;
            }
            this.inPictureElement = false;
        } else if (this.inScreenshot && this.inShapeProperties && qName.equalsIgnoreCase("p:spPr")) {
            this.inShapeProperties = false;
        } else if (this.inShape && qName.equalsIgnoreCase("p:sp")) {
            this.inShape = false;
            if (this.slideShape != null && this.slideShape.getBackgroundColor().equals("FFFF00")) {
                this.labelsList.add(this.slideShape);
            } else {
                this.addShapeToList();
            }
        } else if (this.inArrowShape && qName.equalsIgnoreCase("p:cxnSp")) {
            this.inArrowShape = false;
            this.setRoundedRectangleDragAndDropOrder();
        } else if (this.inShapeBackgroundColor && qName.equalsIgnoreCase("a:solidFill")) {
            this.inShapeBackgroundColor = false;
        } else if (this.inShapeLineProperties && qName.equalsIgnoreCase("a:solidFill")) {
            this.inShapeLineProperties = false;
        } else if (this.inScreenshot && qName.equalsIgnoreCase("p:sp")) {
            this.inScreenshot = false;
        } else if (this.inTextBody && qName.equalsIgnoreCase("p:txBody")) {
            this.inTextBody = false;
            if (this.slideShape != null) {
                this.checkNumeric(this.textBody);
                this.slideShape.setText(this.textBody);
            }
            this.textBody = "";
        }
    }

    private void checkNumeric(String text) {
        try {
            int target_order = Integer.parseInt(text.trim());
            this.isSortedTargets = true;
            this.slideShape.setTargetOrder(target_order);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    private void setRoundedRectangleDragAndDropOrder() {
        if (this.shapesList != null) {
            for (SlideShape mShape : this.shapesList) {
                if (mShape.getId().equals(this.arrowHeadId)) {
                    mShape.setOrder(0);
                    continue;
                }
                if (!mShape.getId().equals(this.arrowEndId)) continue;
                mShape.setOrder(1);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inTextBody) {
            this.textBody = this.textBody + new String(ch, start, length);
            this.textBody = this.textBody + NEW_LINE;
        }
    }

    public Screenshot getScreenshot() {
        return this.originalScreenshot;
    }

    public Sound getSound() {
        return this.mSound;
    }

    private void addShapeToList() {
        if (this.slideShape != null) {
            this.shapesList.add(this.slideShape);
        }
    }

    public List<SlideShape> getShapes() {
        if (this.isSortedTargets) {
            this.sortShapes();
        }
        return this.shapesList;
    }

    private void sortShapes() {
        Collections.sort(this.shapesList);
    }

    public List<SlideShape> getLabels() {
        return this.labelsList;
    }
}

