/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.processing;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageProcessing {
    private static final Logger logger = LoggerFactory.getLogger(ImageProcessing.class);

    public static double scaleRectangleWidth(int rectangleWidth, int resizedScreenshotWidth, int fullScreenshotWidth) {
        return (double)rectangleWidth / (double)resizedScreenshotWidth * (double)fullScreenshotWidth;
    }

    public static double scaleRectangleHeight(int rectangleHeight, int resizedScreenshotHeight, int fullScreenshotHeight) {
        return (double)rectangleHeight / (double)resizedScreenshotHeight * (double)fullScreenshotHeight;
    }

    public static double getRelativeX(int x, int resizedScreenshotWidth, int fullScreenshotWidth) {
        return (double)x * ((double)fullScreenshotWidth / (double)resizedScreenshotWidth);
    }

    public static double getRelativeY(int y, int resizedScreenshotHeight, int fullScreenshotHeight) {
        return (double)y * ((double)fullScreenshotHeight / (double)resizedScreenshotHeight);
    }

    public static BufferedImage createResizedCopy(Image originalImage, int scaledWidth, int scaledHeight, boolean preserveAlpha) {
        int imageType = preserveAlpha ? 1 : 2;
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, imageType);
        Graphics2D g = scaledBI.createGraphics();
        if (preserveAlpha) {
            g.setComposite(AlphaComposite.Src);
        }
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    public static BufferedImage cropImage(URL imageUrl, double xmin, double ymin, double xmax, double ymax) {
        BufferedImage croppedImage = null;
        try {
            BufferedImage imageTocrop = ImageIO.read(imageUrl);
            int x = (int)xmin * imageTocrop.getWidth();
            int y = (int)ymin * imageTocrop.getHeight();
            int width = (int)(xmax - xmin) * imageTocrop.getWidth();
            int height = (int)(ymax - ymin) * imageTocrop.getHeight();
            croppedImage = imageTocrop.getSubimage(x, y, width, height);
            return croppedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RasterFormatException e) {
            logger.error("Error: The shape is not contained within the boundaries of the screenshot.");
            System.exit(1);
        }
        return croppedImage;
    }

    public static BufferedImage cropImage(String imageLocation, int x, int y, int width, int height) {
        BufferedImage croppedImage = null;
        try {
            BufferedImage imageTocrop = ImageIO.read(new File(imageLocation));
            croppedImage = imageTocrop.getSubimage(x, y, width, height);
            return croppedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RasterFormatException e) {
            logger.error("Error: The shape is not contained within the boundaries of the screenshot.");
            System.exit(1);
        }
        return croppedImage;
    }

    public static void writeImageToDisk(BufferedImage bufferedImage, String outputFileAbsoluteName) {
        File outputfile = new File(outputFileAbsoluteName);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

