/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.processing;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sikuli.slides.v1.utils.Constants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Relationship
extends DefaultHandler {
    private String relationshipXMLFile;
    private String mediaFileName;
    private String relationshipID;

    public Relationship(String fileName) {
        this.relationshipXMLFile = Constants.projectDirectory + Constants.RELATIONSHIP_DIRECTORY + fileName + ".rels";
    }

    public String getMediaFileName(String relationshipID) {
        this.relationshipID = relationshipID;
        this.parseDocument();
        return this.mediaFileName;
    }

    private void parseDocument() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.relationshipXMLFile, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Relationship") && this.relationshipID.equals(attributes.getValue("Id"))) {
            this.mediaFileName = new File(attributes.getValue("Target")).getName();
        }
    }
}

