/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.sikuli;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.slides.v1.processing.ImageProcessing;
import org.sikuli.slides.v1.screenshots.SlideTargetRegion;
import org.sikuli.slides.v1.utils.Constants;
import org.sikuli.slides.v1.utils.UserPreferencesEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionSelector {
    private static final Logger logger = LoggerFactory.getLogger(RegionSelector.class);
    private static UserPreferencesEditor prefsEditor = new UserPreferencesEditor();
    private SlideTargetRegion slideTargetRegion;
    private final int widthFactor = 30;
    private final int heightFactor = 30;
    private static AtomicInteger counter;
    private final int TOP = 0;
    private final int BOTTOM = 1;
    private final int RIGHT = 2;
    private final int LEFT = 3;

    public RegionSelector(SlideTargetRegion slideTargetRegion) {
        this.slideTargetRegion = slideTargetRegion;
        counter = new AtomicInteger(0);
    }

    public ScreenRegion findScreenRegion(ImageTarget imageTarget, SlideTargetRegion slideTargetRegion) {
        logger.info("Searching to the right of the target to identify the target image.");
        ScreenRegion s = this.doDirectionalSearch(imageTarget, slideTargetRegion, 2);
        if (s != null) {
            return s;
        }
        logger.info("Searching to the top of the target to identify the target image.");
        s = this.doDirectionalSearch(imageTarget, slideTargetRegion, 0);
        if (s != null) {
            return s;
        }
        logger.info("Searching to the left of the target to identify the target image.");
        s = this.doDirectionalSearch(imageTarget, slideTargetRegion, 3);
        if (s != null) {
            return s;
        }
        logger.info("Searching to the bottom of the target to identify the target image.");
        s = this.doDirectionalSearch(imageTarget, slideTargetRegion, 1);
        if (s != null) {
            return s;
        }
        return null;
    }

    private List<ScreenRegion> getLeftScreenRegionList() {
        ArrayList<ScreenRegion> screenRegions = new ArrayList<ScreenRegion>();
        int regionWidth = this.slideTargetRegion.getWidth();
        for (int i = 0; i < 5; ++i) {
            int leftEdge = this.slideTargetRegion.getX() - (regionWidth += 30);
            int newWidth = regionWidth + this.slideTargetRegion.getWidth();
            if (leftEdge < 0) break;
            DesktopScreenRegion screenRegion = new DesktopScreenRegion(Constants.ScreenId, leftEdge, this.slideTargetRegion.getY(), newWidth, this.slideTargetRegion.getHeight());
            screenRegions.add(screenRegion);
        }
        return screenRegions;
    }

    private List<ScreenRegion> getRightScreenRegionList() {
        int rightEdge;
        ArrayList<ScreenRegion> screenRegions = new ArrayList<ScreenRegion>();
        int regionWidth = this.slideTargetRegion.getWidth();
        for (int i = 0; i < 5 && (rightEdge = this.slideTargetRegion.getX() + (regionWidth += 30)) <= this.slideTargetRegion.getMaxWidth(); ++i) {
            DesktopScreenRegion screenRegion = new DesktopScreenRegion(Constants.ScreenId, this.slideTargetRegion.getX(), this.slideTargetRegion.getY(), regionWidth, this.slideTargetRegion.getHeight());
            screenRegions.add(screenRegion);
        }
        return screenRegions;
    }

    private List<ScreenRegion> getTopScreenRegionList() {
        ArrayList<ScreenRegion> screenRegions = new ArrayList<ScreenRegion>();
        int regionHeight = this.slideTargetRegion.getHeight();
        for (int i = 0; i < 5; ++i) {
            int upperEdge = this.slideTargetRegion.getY() - (regionHeight += 30);
            int newHeight = regionHeight + this.slideTargetRegion.getHeight();
            if (upperEdge < 0) break;
            DesktopScreenRegion screenRegion = new DesktopScreenRegion(Constants.ScreenId, this.slideTargetRegion.getX(), upperEdge, this.slideTargetRegion.getWidth(), newHeight);
            screenRegions.add(screenRegion);
        }
        return screenRegions;
    }

    private List<ScreenRegion> getBottomScreenRegionList() {
        int lowerEdge;
        ArrayList<ScreenRegion> screenRegions = new ArrayList<ScreenRegion>();
        int regionHeight = this.slideTargetRegion.getHeight();
        for (int i = 0; i < 5 && (lowerEdge = this.slideTargetRegion.getY() + (regionHeight += 30)) <= this.slideTargetRegion.getMaxHeight(); ++i) {
            DesktopScreenRegion screenRegion = new DesktopScreenRegion(Constants.ScreenId, this.slideTargetRegion.getX(), this.slideTargetRegion.getY(), this.slideTargetRegion.getWidth(), regionHeight);
            screenRegions.add(screenRegion);
        }
        return screenRegions;
    }

    private ScreenRegion doDirectionalSearch(ImageTarget imageTarget, SlideTargetRegion slideTargetRegion, int direction) {
        List<ScreenRegion> directionScreenRegions;
        DesktopScreenRegion fullScreenRegion = new DesktopScreenRegion(Constants.ScreenId);
        if (direction == 0) {
            directionScreenRegions = this.getTopScreenRegionList();
        } else if (direction == 1) {
            directionScreenRegions = this.getBottomScreenRegionList();
        } else if (direction == 2) {
            directionScreenRegions = this.getRightScreenRegionList();
        } else if (direction == 3) {
            directionScreenRegions = this.getLeftScreenRegionList();
        } else {
            logger.error("Unknown search direction.");
            return null;
        }
        for (ScreenRegion screenRegion : directionScreenRegions) {
            List<ScreenRegion> targetList;
            BufferedImage croppedRegionImage = ImageProcessing.cropImage(slideTargetRegion.getScreenshotPath(), screenRegion.getBounds().x, screenRegion.getBounds().y, screenRegion.getBounds().width, screenRegion.getBounds().height);
            logger.info("Attempt no. " + counter.incrementAndGet());
            ImageTarget newImageTarget = new ImageTarget(croppedRegionImage);
            newImageTarget.setMinScore(prefsEditor.getPreciseSearchScore());
            List<ScreenRegion> lookupRegion = fullScreenRegion.findAll(newImageTarget);
            if (lookupRegion.size() > 1 || lookupRegion.size() != 1 || (targetList = lookupRegion.get(0).findAll(imageTarget)).size() > 1 || targetList.size() != 1) continue;
            logger.info("Target found.");
            return lookupRegion.get(0);
        }
        return null;
    }
}

