/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.sikuli;

import java.util.List;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.slides.v1.screenshots.SlideTargetRegion;
import org.sikuli.slides.v1.sikuli.RegionSelector;
import org.sikuli.slides.v1.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchMultipleTarget {
    private static final Logger logger = LoggerFactory.getLogger(SearchMultipleTarget.class);

    public boolean hasMultipleOccurance(ImageTarget imageTarget) {
        DesktopScreenRegion fullScreenRegion = new DesktopScreenRegion(Constants.ScreenId);
        List<ScreenRegion> targetList = fullScreenRegion.findAll(imageTarget);
        if (targetList != null && targetList.size() > 1) {
            logger.info("Found " + targetList.size() + " similar targets on the screen.");
            return true;
        }
        return false;
    }

    public ScreenRegion findNewScreenRegion(SlideTargetRegion slideTargetRegion, ImageTarget imageTarget) {
        RegionSelector regionSelector = new RegionSelector(slideTargetRegion);
        ScreenRegion newScreenRegion = regionSelector.findScreenRegion(imageTarget, slideTargetRegion);
        if (newScreenRegion != null) {
            return newScreenRegion.find(imageTarget);
        }
        return null;
    }
}

