/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.sikuli;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.sikuli.api.API;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.robot.desktop.DesktopKeyboard;
import org.sikuli.api.robot.desktop.DesktopMouse;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.ScreenRegionCanvas;
import org.sikuli.slides.v1.core.SlideComponent;
import org.sikuli.slides.v1.media.Sound;
import org.sikuli.slides.v1.screenshots.SlideTargetRegion;
import org.sikuli.slides.v1.shapes.SlideShape;
import org.sikuli.slides.v1.sikuli.SearchMultipleTarget;
import org.sikuli.slides.v1.sikuli.SlideTutorial;
import org.sikuli.slides.v1.utils.Constants;
import org.sikuli.slides.v1.utils.MyScreen;
import org.sikuli.slides.v1.utils.UnitConverter;
import org.sikuli.slides.v1.utils.UserPreferencesEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlideAction {
    private static final Logger logger = LoggerFactory.getLogger(SlideAction.class);
    private UserPreferencesEditor prefsEditor = new UserPreferencesEditor();
    private File targetFile;
    private File labelFile;
    private SlideShape slideShape;
    private SlideTargetRegion slideTargetRegion;
    private SlideTargetRegion slideLabelRegion;
    private Sound sound;
    private SlideShape slideLabel;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public SlideAction(SlideComponent slideComponent) {
        this.targetFile = slideComponent.getTargetFile();
        this.slideShape = slideComponent.getSlideShape();
        this.slideTargetRegion = slideComponent.getSlideTargetRegion();
        this.sound = slideComponent.getSound();
        this.slideLabel = slideComponent.getSlideLabel();
        this.labelFile = slideComponent.getLabelFile();
        this.slideLabelRegion = slideComponent.getSlideLabelRegion();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doSlideAction(Constants.DesktopEvent desktopEvent) {
        if (desktopEvent == Constants.DesktopEvent.WAIT) {
            this.performNonSikuliAction();
            this.performSikuliAction(null, desktopEvent);
            return;
        }
        if (desktopEvent == Constants.DesktopEvent.LAUNCH_BROWSER) {
            this.performNonSikuliAction();
            this.performSikuliAction(null, desktopEvent);
            return;
        }
        if (desktopEvent == null && this.slideLabel != null) {
            this.performNonSikuliAction();
            return;
        }
        if (desktopEvent == null && this.sound != null) {
            this.performNonSikuliAction();
            return;
        }
        ScreenRegion targetRegion = this.findTargetRegion(this.targetFile, this.slideTargetRegion, this.prefsEditor.getPreciseSearchScore());
        if (targetRegion == null) {
            targetRegion = this.retryFindTargetRegion(this.targetFile, this.slideTargetRegion);
        }
        this.performNonSikuliAction();
        if (desktopEvent == Constants.DesktopEvent.EXIST) {
            logger.info("Checking whether the target image is visible on the screen.");
            if (targetRegion == null) {
                logger.error("Test failed. Target image was not found on the screen.");
                System.exit(1);
                return;
            }
            logger.info("Test passed. Target image was found on the screen.");
            return;
        }
        if (desktopEvent == Constants.DesktopEvent.NOT_EXIST) {
            logger.info("Checking whether the target image is invisible on the screen.");
            if (targetRegion == null) {
                logger.info("Test passed. Target image was invisible on the screen.");
                return;
            }
            logger.error("Test failed. Target image was visible on the screen.");
            System.exit(1);
            return;
        }
        if (targetRegion == null) {
            return;
        }
        if (Constants.HELP_MODE) {
            new SlideTutorial(targetRegion, this.slideShape, desktopEvent).performTutorialSlideAction();
            return;
        }
        if (Constants.TUTORIAL_MODE) {
            new SlideTutorial(targetRegion, this.slideShape, desktopEvent).performTutorialSlideAction();
            return;
        }
        this.performSikuliAction(targetRegion, desktopEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ScreenRegion findTargetRegion(File targetFile, SlideTargetRegion slideTargetRegion, double minScore) {
        ImageTarget imageTarget = new ImageTarget(targetFile);
        imageTarget.setMinScore(minScore);
        if (imageTarget == null) return null;
        DesktopScreenRegion fullScreenRegion = new DesktopScreenRegion(Constants.ScreenId);
        ScreenRegion targetRegion = fullScreenRegion.wait(imageTarget, this.prefsEditor.getMaxWaitTime());
        if (targetRegion != null) {
            SearchMultipleTarget searchMultipleTarget = new SearchMultipleTarget();
            if (!searchMultipleTarget.hasMultipleOccurance(imageTarget)) return targetRegion;
            ScreenRegion newScreenRegion = searchMultipleTarget.findNewScreenRegion(slideTargetRegion, imageTarget);
            if (newScreenRegion != null) {
                return newScreenRegion.find(imageTarget);
            }
        } else {
            if (!(minScore <= 0.4)) return null;
            logger.error("Failed to find target on the screen. Slide no. " + slideTargetRegion.getslideNumber());
            return null;
        }
        logger.error("Failed to determine the target image among multiple similar targets on the screen." + NEW_LINE + "Try to resize the shape in slide number {} to make the search more accurate.", (Object)slideTargetRegion.getslideNumber());
        return null;
    }

    private ScreenRegion retryFindTargetRegion(File targetFile, SlideTargetRegion slideTargetRegion) {
        ScreenRegion targetRegion = null;
        double minScore = 1.0;
        while (minScore > 0.4 && targetRegion == null) {
            targetRegion = this.findTargetRegion(targetFile, slideTargetRegion, minScore -= 0.1);
        }
        return targetRegion;
    }

    private void performNonSikuliAction() {
        if (this.sound != null) {
            this.sound.playSound();
        }
        if (this.slideLabel != null) {
            ScreenRegion labelScreenRegion = null;
            if (this.labelFile != null && this.slideLabelRegion != null && (labelScreenRegion = this.findTargetRegion(this.labelFile, this.slideLabelRegion, this.prefsEditor.getPreciseSearchScore())) == null) {
                labelScreenRegion = this.retryFindTargetRegion(this.targetFile, this.slideTargetRegion);
            }
            this.displayLabel(labelScreenRegion);
        }
    }

    private void performSikuliAction(ScreenRegion targetRegion, Constants.DesktopEvent desktopEvent) {
        if (desktopEvent == Constants.DesktopEvent.LEFT_CLICK) {
            this.performLeftClick(targetRegion);
        } else if (desktopEvent == Constants.DesktopEvent.RIGHT_CLICK) {
            this.performRightClick(targetRegion);
        } else if (desktopEvent == Constants.DesktopEvent.DOUBLE_CLICK) {
            this.performDoubleClick(targetRegion);
        } else if (desktopEvent == Constants.DesktopEvent.DRAG_N_DROP) {
            this.performDragDrop(targetRegion);
        } else if (desktopEvent == Constants.DesktopEvent.KEYBOARD_TYPING) {
            this.performKeyboardTyping(targetRegion);
        } else if (desktopEvent == Constants.DesktopEvent.LAUNCH_BROWSER) {
            this.performLaunchWebBrowser();
        } else if (desktopEvent == Constants.DesktopEvent.WAIT) {
            this.performWaitAction();
        }
    }

    private void displayLabel(ScreenRegion targetRegion) {
        double fontSize;
        if (targetRegion == null) {
            logger.error("Failed to find the target to display a label on.");
            logger.info("Displaying the label on the center of the screen.");
            Dimension dimension = MyScreen.getScreenDimensions();
            int width = UnitConverter.emuToPixels(this.slideLabel.getCx());
            int height = UnitConverter.emuToPixels(this.slideLabel.getCy());
            int x = (dimension.width - width) / 2;
            int y = (dimension.height - height) / 2;
            targetRegion = new DesktopScreenRegion(Constants.ScreenId, x, y, width, height);
        }
        if ((fontSize = UnitConverter.WholePointsToPoints(this.slideLabel.getTextSize())) == 0.0) {
            fontSize = this.prefsEditor.getInstructionHintFontSize();
        }
        ScreenRegionCanvas canvas = new ScreenRegionCanvas(new DesktopScreenRegion(Constants.ScreenId));
        canvas.addLabel(targetRegion.getUpperLeftCorner(), this.slideLabel.getText()).withColor(Color.black).withFontSize((int)fontSize).withLineWidth(this.prefsEditor.getCanvasWidthSize());
        ((Canvas)canvas).display(this.prefsEditor.getLabelDisplayTime());
    }

    private void performLeftClick(ScreenRegion targetRegion) {
        logger.info("performing left click event on target...");
        DesktopMouse mouse = new DesktopMouse();
        this.displayBoxOnRegion(targetRegion);
        mouse.click(targetRegion.getCenter());
    }

    private void performRightClick(ScreenRegion targetRegion) {
        logger.info("performing right click event on target...");
        DesktopMouse mouse = new DesktopMouse();
        this.displayBoxOnRegion(targetRegion);
        mouse.rightClick(targetRegion.getCenter());
    }

    private void performDoubleClick(ScreenRegion targetRegion) {
        logger.info("performing double click event on target...");
        DesktopMouse mouse = new DesktopMouse();
        this.displayBoxOnRegion(targetRegion);
        mouse.doubleClick(targetRegion.getCenter());
    }

    private void performDragDrop(ScreenRegion targetRegion) {
        logger.info("performing drag and drop event on targets...");
        DesktopMouse mouse = new DesktopMouse();
        if (this.slideShape.getOrder() == 0) {
            this.displayBoxOnRegion(targetRegion);
            mouse.drag(targetRegion.getCenter());
        } else if (this.slideShape.getOrder() == 1) {
            this.displayBoxOnRegion(targetRegion);
            mouse.drop(targetRegion.getCenter());
        } else {
            logger.error("Couldn't find the start and end of the straight arrow connector that is used to connect the rounded rectangles. Make sure the arrow is connected to the two rounded rectangles.");
        }
    }

    private void performKeyboardTyping(ScreenRegion targetRegion) {
        logger.info("performing keyboard typing event on target...");
        DesktopMouse mouse = new DesktopMouse();
        DesktopKeyboard keyboard = new DesktopKeyboard();
        this.displayBoxOnRegion(targetRegion);
        mouse.click(targetRegion.getCenter());
        keyboard.type(this.slideShape.getText());
    }

    private void performLaunchWebBrowser() {
        logger.info("launching the default browser...");
        try {
            String userURL = this.slideShape.getText();
            URL url = null;
            url = userURL.startsWith("http://") ? new URL(userURL) : new URL("http://" + userURL);
            API.browse(url);
        }
        catch (MalformedURLException e) {
            logger.error("The text body of the Cloud shape doesn't contain a valid URL.");
            System.exit(1);
        }
    }

    private void performWaitAction() {
        String waitTimeString;
        logger.info("Performing wait action...");
        TimeUnit timeUnit = UnitConverter.extractTimeUnitFromString(this.slideShape.getText());
        if (timeUnit == null) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((waitTimeString = this.slideShape.getText().replaceAll("\\D", "")) == null) {
            logger.error("Error: Please enter the wait time value in a shape. Valid examples include: 10 seconds, 10 minutes, 10 hours, or even 2 days.");
            return;
        }
        try {
            long timeout = Long.parseLong(waitTimeString);
            if (Constants.TUTORIAL_MODE) {
                Constants.IsWaitAction = true;
            }
            Dimension dimension = MyScreen.getScreenDimensions();
            DesktopScreenRegion canvasRegion = new DesktopScreenRegion(Constants.ScreenId, 0, dimension.height - 200, 50, 200);
            ScreenRegionCanvas canvas = new ScreenRegionCanvas(new DesktopScreenRegion(Constants.ScreenId));
            String readyTime = this.getReadyDate(timeUnit, timeout);
            String waitMessage = "Please wait for " + timeout + " " + timeUnit.toString().toLowerCase() + "...." + "This might end at " + readyTime;
            logger.info(waitMessage);
            canvas.addLabel(canvasRegion, waitMessage).withFontSize(this.prefsEditor.getInstructionHintFontSize());
            ((Canvas)canvas).show();
            timeUnit.sleep(timeout);
            Constants.IsWaitAction = false;
            ((Canvas)canvas).hide();
            logger.info("Wait time has been reached ...");
        }
        catch (NumberFormatException e) {
            logger.error("Error: Invalid wait time.");
        }
        catch (InterruptedException e) {
            logger.error("Error in wait operation");
        }
    }

    private String getReadyDate(TimeUnit timeUnit, long timeout) {
        if (timeUnit != null) {
            String dateFormat = "HH:mm:ss";
            if (timeUnit == TimeUnit.DAYS) {
                dateFormat = "yyyy-MM-dd HH:mm:ss";
            }
            long waitTimeInMilliSeconds = timeUnit.toMillis(timeout);
            Calendar nowCalendar = Calendar.getInstance();
            Calendar timeoutCalendar = Calendar.getInstance();
            timeoutCalendar.setTimeInMillis(waitTimeInMilliSeconds + nowCalendar.getTimeInMillis());
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            return sdf.format(timeoutCalendar.getTime()).toString();
        }
        return null;
    }

    private void displayBoxOnRegion(ScreenRegion screenRegion) {
        if (screenRegion != null) {
            ScreenRegionCanvas canvas = new ScreenRegionCanvas(screenRegion);
            canvas.addBox(screenRegion);
            ((Canvas)canvas).display(2);
        }
    }
}

