/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.sikuli;

import java.awt.Color;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.ScreenRegionCanvas;
import org.sikuli.slides.v1.listeners.GlobalKeyboardListeners;
import org.sikuli.slides.v1.listeners.GlobalMouseListeners;
import org.sikuli.slides.v1.shapes.SlideShape;
import org.sikuli.slides.v1.utils.Constants;
import org.sikuli.slides.v1.utils.UserPreferencesEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlideTutorial {
    private static final Logger logger = LoggerFactory.getLogger(SlideTutorial.class);
    private UserPreferencesEditor prefsEditor = new UserPreferencesEditor();
    private ScreenRegion targetRegion;
    private Constants.DesktopEvent desktopEvent;
    private SlideShape slideShape;

    public SlideTutorial(ScreenRegion targetRegion, SlideShape slideShape, Constants.DesktopEvent desktopEvent) {
        this.targetRegion = targetRegion;
        this.slideShape = slideShape;
        this.desktopEvent = desktopEvent;
    }

    private String getActionDisplayName() {
        if (this.desktopEvent == Constants.DesktopEvent.LEFT_CLICK) {
            return "Click here";
        }
        if (this.desktopEvent == Constants.DesktopEvent.DOUBLE_CLICK) {
            return "Double click here";
        }
        if (this.desktopEvent == Constants.DesktopEvent.RIGHT_CLICK) {
            return "Right click here";
        }
        if (this.desktopEvent == Constants.DesktopEvent.DRAG_N_DROP) {
            if (this.slideShape.getOrder() == 0) {
                return "Drag this";
            }
            if (this.slideShape.getOrder() == 1) {
                return "and drop it here";
            }
        } else if (this.desktopEvent == Constants.DesktopEvent.KEYBOARD_TYPING) {
            return "Click and type: " + this.slideShape.getText() + " here";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performTutorialSlideAction() {
        if (this.targetRegion == null) {
            return;
        }
        ScreenRegionCanvas canvas = new ScreenRegionCanvas(new DesktopScreenRegion(Constants.ScreenId));
        canvas.addBox(this.targetRegion).withLineWidth(this.prefsEditor.getCanvasWidthSize());
        int x = this.targetRegion.getBounds().x;
        int y = this.targetRegion.getBounds().y;
        int w = this.targetRegion.getBounds().width;
        int h = this.targetRegion.getBounds().height;
        DesktopScreenRegion labelRegion = new DesktopScreenRegion(Constants.ScreenId, x, y - h, w, h);
        canvas.addLabel(labelRegion, this.getActionDisplayName()).withColor(Color.black).withFontSize(this.prefsEditor.getInstructionHintFontSize());
        logger.info("Waiting for the user to pefrom " + this.desktopEvent.toString() + " on the highlighted target.");
        try {
            if (!GlobalScreen.isNativeHookRegistered()) {
                GlobalScreen.registerNativeHook();
            }
            if (this.desktopEvent == Constants.DesktopEvent.KEYBOARD_TYPING) {
                GlobalKeyboardListeners globalKeyboardListener = new GlobalKeyboardListeners(this.targetRegion, this.slideShape.getText(), this.desktopEvent);
                GlobalScreen.getInstance().addNativeKeyListener(globalKeyboardListener);
                ((Canvas)canvas).displayWhile(globalKeyboardListener);
                GlobalScreen.getInstance().removeNativeKeyListener(globalKeyboardListener);
                return;
            }
            if (this.desktopEvent == Constants.DesktopEvent.LEFT_CLICK || this.desktopEvent == Constants.DesktopEvent.RIGHT_CLICK || this.desktopEvent == Constants.DesktopEvent.DOUBLE_CLICK || this.desktopEvent == Constants.DesktopEvent.DRAG_N_DROP) {
                GlobalMouseListeners globalMouseListener = new GlobalMouseListeners(this.targetRegion, this.desktopEvent);
                GlobalScreen.getInstance().addNativeMouseListener(globalMouseListener);
                ((Canvas)canvas).displayWhile(globalMouseListener);
                GlobalScreen.getInstance().removeNativeMouseListener(globalMouseListener);
                return;
            }
            if (this.desktopEvent != Constants.DesktopEvent.LAUNCH_BROWSER && this.desktopEvent != Constants.DesktopEvent.EXIST && this.desktopEvent != Constants.DesktopEvent.NOT_EXIST) return;
        }
        catch (NativeHookException ex) {
            logger.error("There was a problem in running the tutorial mode. " + ex.getMessage());
            System.exit(1);
        }
    }
}

