/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.utils;

import java.util.prefs.Preferences;
import org.sikuli.api.robot.desktop.DesktopScreen;
import org.sikuli.slides.v1.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPreferencesEditor {
    private static final Logger logger = LoggerFactory.getLogger(UserPreferencesEditor.class);
    private Preferences prefs = Preferences.userNodeForPackage(UserPreferencesEditor.class);
    private static final String NEW_LINE = System.getProperty("line.separator");

    public double getPreciseSearchScore() {
        return this.prefs.getDouble("precise_search_score", 0.7);
    }

    public void putPreciseSearchScore(int PRECISE_SEARCH_SCORE_VALUE) {
        if (PRECISE_SEARCH_SCORE_VALUE > 0 && PRECISE_SEARCH_SCORE_VALUE <= 10) {
            double score = (double)PRECISE_SEARCH_SCORE_VALUE / 10.0;
            this.prefs.putDouble("precise_search_score", score);
        } else {
            logger.error("Invalid precision score value. Please enter a valid score value.{}Accepted values are between 1 and 10, where 1 is the least precise search and 10 is the most precise search.", (Object)NEW_LINE);
        }
    }

    public int getMaxWaitTime() {
        return this.prefs.getInt("max_wait_time_ms", Constants.MAX_WAIT_TIME_MS_DEFAULT);
    }

    public void putMaxWaitTime(int MAX_WAIT_TIME_MS_NEW_VALUE) {
        if (MAX_WAIT_TIME_MS_NEW_VALUE < 0) {
            logger.error("Invalid maximum wait time value. Please enter the maximum wait time in milliseconds.");
            return;
        }
        this.prefs.putInt("max_wait_time_ms", MAX_WAIT_TIME_MS_NEW_VALUE);
    }

    public int getDisplayId() {
        return this.prefs.getInt("display_id", Constants.DISPLAY_ID_DEFAULT);
    }

    public void putDisplayId(int DISPLAY_ID_VALUE) {
        if (DISPLAY_ID_VALUE < 0 || DISPLAY_ID_VALUE >= DesktopScreen.getNumberScreens()) {
            logger.error("Invalid display id. Please enter a valid display id. Example: 0 refers to the main display, 1 is the secondary display, etc.");
            logger.info("resetting default screen to main display, screen 0");
            this.prefs.putInt("display_id", 0);
            Constants.ScreenId = 0;
            return;
        }
        this.prefs.putInt("display_id", DISPLAY_ID_VALUE);
        Constants.ScreenId = DISPLAY_ID_VALUE;
    }

    public int getLabelDisplayTime() {
        return this.prefs.getInt("label_display_time_sec", 3);
    }

    public void putLabelDisplayTime(int LABEL_DISPLAY_TIME_SEC_NEW_VALUE) {
        if (LABEL_DISPLAY_TIME_SEC_NEW_VALUE < 0) {
            logger.error("Invalid label display time value. Please enter the time, in seconds, to display a label on the screen.");
            return;
        }
        this.prefs.putInt("label_display_time_sec", LABEL_DISPLAY_TIME_SEC_NEW_VALUE);
    }

    public int getInstructionHintFontSize() {
        return this.prefs.getInt("instruction_hint_font_size", Constants.INSTRUCTION_HINT_FONT_SIZE_DEFAULT);
    }

    public void putInstructionHintFontSize(int INSTRUCTION_HINT_FONT_SIZE_NEW_VALUE) {
        if (INSTRUCTION_HINT_FONT_SIZE_NEW_VALUE < 0) {
            logger.error("Invalid instruction hint (tooltip) font size. Please enter a valid font size, in points.");
            return;
        }
        this.prefs.putInt("instruction_hint_font_size", INSTRUCTION_HINT_FONT_SIZE_NEW_VALUE);
    }

    public int getCanvasWidthSize() {
        return this.prefs.getInt("canvas_width_size", Constants.CANVAS_WIDTH_SIZE_DEFAULT);
    }

    public void putCanvasWidthSize(int CANVAS_WIDTH_SIZE_NEW_VALUE) {
        if (CANVAS_WIDTH_SIZE_NEW_VALUE < 0) {
            logger.error("Invalid canvas width size. Please enter a valid width size, in points.");
            return;
        }
        this.prefs.putInt("canvas_width_size", CANVAS_WIDTH_SIZE_NEW_VALUE);
    }
}

