/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.v1.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.sikuli.slides.v1.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean createWorkingDirectory() {
        File tmpDirectory;
        try {
            tmpDirectory = FileUtils.getTempDirectory();
        }
        catch (IllegalStateException e) {
            return false;
        }
        if (tmpDirectory.exists()) {
            File workingDirectory = new File(tmpDirectory.getAbsoluteFile() + File.separator + "org.sikuli.SikuliSlides");
            Constants.workingDirectoryPath = workingDirectory.getAbsolutePath();
            if (workingDirectory.exists()) {
                return true;
            }
            return workingDirectory.mkdir();
        }
        return false;
    }

    public static void doZipFile(File file) {
        byte[] buffer = new byte[1024];
        try {
            int len;
            FileOutputStream fos = new FileOutputStream(Constants.workingDirectoryPath + File.separator + file.getName() + ".zip");
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry(file.getName());
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(file.getAbsolutePath());
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void doUnZipFile(File file) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(Constants.workingDirectoryPath + File.separator + file.getName().substring(0, file.getName().indexOf(46)));
            if (!folder.exists()) {
                folder.mkdir();
            } else {
                FileUtils.deleteDirectory(folder);
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file.getAbsoluteFile()));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(folder + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            File zipFile = new File(Constants.workingDirectoryPath + File.separator + file.getName() + ".zip");
            if (zipFile.delete()) {
                return;
            }
            logger.error("Couldn't delete zip: " + Constants.workingDirectoryPath + File.separator + file.getName() + ".zip");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void createSikuliImagesDirectory() {
        File folder = new File(Constants.projectDirectory + File.separator + Constants.SIKULI_DIRECTORY);
        File imagesFolder = new File(Constants.projectDirectory + File.separator + Constants.SIKULI_DIRECTORY + File.separator + Constants.IMAGES_DIRECTORY);
        if (!folder.exists()) {
            folder.mkdir();
            imagesFolder.mkdir();
        }
    }

    public static void openURLInBrowser(String URLString) {
        try {
            Desktop desktop;
            URI uri = new URI(URLString);
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(uri);
            }
        }
        catch (Exception e) {
            logger.error("Failed to open the following URL: " + URLString);
        }
    }

    public static File downloadFile(String URL2) {
        URL downloadURL = Utils.getDownloadLink(URL2);
        if (downloadURL == null) {
            logger.error("Error: Invalid URL.");
            return null;
        }
        File destination = null;
        try {
            File directory = new File(Constants.workingDirectoryPath + Constants.SIKULI_DOWNLOAD_DIRECTORY);
            directory.mkdir();
            destination = File.createTempFile("download", ".pptx", directory);
            logger.info("The file is being downloaded, please wait...");
            FileUtils.copyURLToFile(downloadURL, destination, 300000, 30000);
            logger.info("Download complete.");
        }
        catch (IOException e) {
            logger.error("Error while downloading the file.");
            destination = null;
        }
        catch (NullPointerException npe) {
            logger.error("Error while downloading the file.");
            destination = null;
        }
        return destination;
    }

    private static URL getDownloadLink(String downloadLink) {
        block8: {
            if (downloadLink != null) {
                try {
                    String domainName;
                    URI uri = new URI(downloadLink);
                    String domain = uri.getHost();
                    if (domain == null) {
                        return null;
                    }
                    String string = domainName = domain.startsWith("www.") ? domain.substring(4) : domain;
                    if (domainName.equalsIgnoreCase("docs.google.com")) {
                        try {
                            int startIndex = downloadLink.indexOf("/d/") + 3;
                            int lastIndex = downloadLink.indexOf("/edit");
                            String documentId = downloadLink.substring(startIndex, lastIndex);
                            String gDriveDownloadLink = "https://docs.google.com/presentation/d/" + documentId + "/export/pptx";
                            return new URL(gDriveDownloadLink);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            logger.error("ERROR: Invalid Google Drive link.");
                            break block8;
                        }
                    }
                    return new URL(downloadLink);
                }
                catch (URISyntaxException e) {
                    logger.error("ERROR: Invalid share link.");
                }
                catch (MalformedURLException e) {
                    logger.error("ERROR: Invalid share link.");
                }
            }
        }
        return null;
    }
}

