/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.badge4j;

import org.silentsoft.badge4j.BadgeBuilder;
import org.silentsoft.badge4j.BadgeRenderer;
import org.silentsoft.badge4j.NamedColor;
import org.silentsoft.badge4j.NamedColorAlias;
import org.silentsoft.badge4j.Style;
import org.silentsoft.csscolor4j.Color;

public class Badge {
    private BadgeBuilder badgeBuilder;

    private Badge() {
    }

    Badge(BadgeBuilder badgeBuilder) {
        this.badgeBuilder = badgeBuilder;
    }

    String build() {
        Style style = this.badgeBuilder.style != null ? this.badgeBuilder.style : Style.Flat;
        String label = this.badgeBuilder.label != null ? this.badgeBuilder.label.trim() : null;
        String message = this.badgeBuilder.message.trim();
        String color = this.badgeBuilder.color != null && this.badgeBuilder.color.length() > 0 ? this.badgeBuilder.color : "#4c1";
        String string = NamedColor.nameOf(color = color.trim()) != null ? NamedColor.nameOf(color).getHex() : (color = NamedColorAlias.nameOf(color) != null ? NamedColorAlias.nameOf(color).getHex() : color);
        if (!color.startsWith("#") && org.silentsoft.csscolor4j.NamedColor.nameOf((String)color) == null) {
            color = Color.valueOf((String)color).getHex();
        }
        String labelColor = this.badgeBuilder.labelColor != null && this.badgeBuilder.labelColor.length() > 0 ? this.badgeBuilder.labelColor : "#555";
        String string2 = NamedColor.nameOf(labelColor = labelColor.trim()) != null ? NamedColor.nameOf(labelColor).getHex() : (labelColor = NamedColorAlias.nameOf(labelColor) != null ? NamedColorAlias.nameOf(labelColor).getHex() : labelColor);
        if (!labelColor.startsWith("#") && org.silentsoft.csscolor4j.NamedColor.nameOf((String)labelColor) == null) {
            labelColor = Color.valueOf((String)labelColor).getHex();
        }
        String[] links = this.badgeBuilder.links;
        String logo = this.badgeBuilder.logo;
        int logoWidth = this.badgeBuilder.logoWidth;
        if (logoWidth <= 0) {
            logoWidth = logo == null || "".equals(logo) ? 0 : 14;
        }
        return this.stripXmlWhitespace(BadgeRenderer.get(style).render(label, message, color, labelColor, links, logo, logoWidth));
    }

    private String stripXmlWhitespace(String value) {
        return value.replaceAll(">\\s+", ">").replaceAll("<\\s+", "<");
    }

    public static BadgeBuilder builder() {
        return new BadgeBuilder();
    }
}

