/*
 * Decompiled with CFR 0.152.
 */
package org.simonscode.telegrambots.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.simonscode.telegrambots.framework.BotInfo;
import org.simonscode.telegrambots.framework.Config;
import org.simonscode.telegrambots.framework.Module;
import org.simonscode.telegrambots.framework.ModuleInfo;
import org.simonscode.telegrambots.framework.State;
import org.telegram.telegrambots.api.objects.Update;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;

public class Bot
extends TelegramLongPollingBot {
    private final BotInfo botInfo;
    private final Object MODULES_LOCK;
    private final Object MODULE_INFO_LOCK;
    private final Object MODULES_ADD_LOCK;
    private final Object MODULES_REMOVE_LOCK;
    private List<Module> modules;
    private List<Module> modulesToAdd;
    private List<Module> modulesToRemove;
    private List<ModuleInfo> moduleInfos;

    public Bot(String username, String apiKey, List<Module> modules) {
        this(new BotInfo(username, apiKey, new HashMap<String, State>()));
        this.modules.addAll(modules);
    }

    Bot(BotInfo botInfo) {
        this.botInfo = botInfo;
        this.modules = new ArrayList<Module>();
        this.moduleInfos = new ArrayList<ModuleInfo>();
        this.modulesToAdd = new ArrayList<Module>();
        this.modulesToRemove = new ArrayList<Module>();
        this.MODULES_LOCK = new Object();
        this.MODULE_INFO_LOCK = new Object();
        this.MODULES_ADD_LOCK = new Object();
        this.MODULES_REMOVE_LOCK = new Object();
        System.out.println("Starting Bot: " + botInfo.getName() + "...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdateReceived(Update update) {
        Object object = this.MODULES_LOCK;
        synchronized (object) {
            this.modules.parallelStream().forEach(module -> {
                try {
                    module.processUpdate(this, update);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
        }
        this.updateModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateModules() {
        Object object = this.MODULES_LOCK;
        synchronized (object) {
            Object object2 = this.MODULE_INFO_LOCK;
            synchronized (object2) {
                Object object3 = this.MODULES_REMOVE_LOCK;
                synchronized (object3) {
                    this.modulesToRemove.forEach(it -> it.preUnload(this));
                    this.modules.removeAll(this.modulesToRemove);
                    this.modulesToRemove.stream().map(Module::getModuleInfo).forEach(this.moduleInfos::remove);
                    this.modulesToRemove.forEach(m -> m.postUnload(this));
                    this.modulesToRemove.clear();
                }
                object3 = this.MODULES_ADD_LOCK;
                synchronized (object3) {
                    this.modulesToAdd.removeAll(this.modules);
                    this.modules.addAll(this.modulesToAdd);
                    this.modulesToAdd.stream().map(Module::getModuleInfo).forEach(this.moduleInfos::add);
                    this.modulesToAdd.forEach(m -> m.postLoad(this));
                    this.modulesToAdd.clear();
                }
            }
        }
    }

    @Override
    public String getBotUsername() {
        return this.botInfo.getName();
    }

    @Override
    public String getBotToken() {
        return this.botInfo.getApiKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosing() {
        Object object = this.MODULES_LOCK;
        synchronized (object) {
            for (Module module : this.modules) {
                this.botInfo.setModuleState(module.getModuleInfo().getModuleId(), module.saveState(this));
            }
            Config.getInstance().save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableModule(Module module) {
        Object object = this.MODULES_ADD_LOCK;
        synchronized (object) {
            this.modulesToAdd.add(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableModule(Module module) {
        Object object = this.MODULES_REMOVE_LOCK;
        synchronized (object) {
            if (!this.modulesToRemove.contains(module)) {
                this.modulesToRemove.add(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModuleInfo> getModules() {
        Object object = this.MODULE_INFO_LOCK;
        synchronized (object) {
            return this.moduleInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveModuleStates() {
        Object object = this.MODULES_LOCK;
        synchronized (object) {
            for (Module module : this.modules) {
                try {
                    State state = module.saveState(this);
                    if (state == null) continue;
                    this.botInfo.getModuleData().put(module.getModuleInfo().getModuleId(), state);
                }
                catch (Throwable t) {
                    System.err.printf("Module %s threw an error while saving:\n", module.getModuleInfo().getModuleId());
                    t.printStackTrace();
                }
            }
        }
    }
}

