/*
 * Decompiled with CFR 0.152.
 */
package org.simonscode.telegrambots.framework;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.simonscode.telegrambots.framework.BotInfo;
import org.simonscode.telegrambots.framework.State;

public class Config {
    private static final String CONFIGFILE = "botconfig.json";
    private static Config instance;
    public ArrayList<BotInfo> bots = new ArrayList();

    public Config() {
        this.bots.add(new BotInfo("BOT0", "APIKEY HERE", new HashMap<String, State>()));
    }

    static Config getInstance() {
        if (instance == null) {
            Config.load(new File(CONFIGFILE));
        }
        return instance;
    }

    static void load(File file) {
        try {
            Gson gson = new GsonBuilder().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            instance = gson.fromJson((Reader)reader, Config.class);
        }
        catch (FileNotFoundException e) {
            System.err.println("Config file not found!\nI created one for you as an example.");
            if (instance == null) {
                instance = new Config();
                instance.save();
                System.exit(1);
            }
        }
        catch (JsonIOException | JsonSyntaxException e) {
            System.err.println("Config file improperly formatted!");
            e.printStackTrace();
        }
    }

    void save() {
        this.save(new File(CONFIGFILE));
    }

    void save(File file) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonConfig = gson.toJson(this);
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(jsonConfig);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

