/*
 * Decompiled with CFR 0.152.
 */
package org.simonscode.telegrambots.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.simonscode.telegrambots.framework.Bot;
import org.simonscode.telegrambots.framework.BotInfo;
import org.simonscode.telegrambots.framework.Config;
import org.simonscode.telegrambots.framework.ModuleLoader;
import org.telegram.telegrambots.ApiContextInitializer;
import org.telegram.telegrambots.TelegramBotsApi;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.generics.BotSession;

public class Controller {
    private static final List<BotSession> sessions = new ArrayList<BotSession>();
    private static List<Bot> bots = new ArrayList<Bot>();
    private static Map<String, String> availableCommands = new HashMap<String, String>();

    public static void main(String[] args) {
        ApiContextInitializer.init();
        ModuleLoader moduleLoader = new ModuleLoader();
        try {
            TelegramBotsApi telegramBotsApi = new TelegramBotsApi();
            Config cfg = Config.getInstance();
            for (BotInfo config : cfg.bots) {
                Bot bot = new Bot(config);
                moduleLoader.loadModules(bot, config.getModuleData());
                bot.updateModules();
                bots.add(bot);
            }
            for (Bot bot : bots) {
                sessions.add(telegramBotsApi.registerBot(bot));
            }
        }
        catch (TelegramApiRequestException e) {
            e.printStackTrace();
        }
        Config.getInstance().save();
        Scanner sc = new Scanner(System.in);
        block29: while (true) {
            String line;
            if ((line = sc.nextLine()).isEmpty()) {
                continue;
            }
            String[] command = line.trim().split(" ");
            switch (command[0].toLowerCase()) {
                case "exit": 
                case "quit": 
                case "q": {
                    break block29;
                }
                case "join": 
                case "j": {
                    System.err.println("Leaving not yet implemented!");
                    continue block29;
                }
                case "leave": 
                case "l": {
                    System.err.println("Leaving not yet implemented!");
                    continue block29;
                }
                case "toogle": {
                    if (command.length != 2) continue block29;
                    switch (command[1]) {
                        case "chat": {
                            break;
                        }
                    }
                    continue block29;
                }
                case "help": 
                case "?": {
                    System.out.println("Available commands:");
                    availableCommands.forEach((key, value) -> System.out.printf("\t\t$-20%s ==> %s\n", key, value));
                    System.out.println();
                    continue block29;
                }
                default: {
                    System.out.println("Unknown command: " + line);
                    continue block29;
                }
            }
            break;
        }
        Controller.stop();
    }

    public static void stop() {
        System.out.print("Stopping running bots...");
        for (BotSession session : sessions) {
            session.stop();
        }
        System.out.println("Done!");
        System.out.print("Saving states...");
        Config.getInstance().save();
        System.out.println("Done!");
    }

    static {
        availableCommands.put("exit / quit", "Stops the framework");
        availableCommands.put("help / ?", "Prints this info message");
        availableCommands.put("join <channel id>", "Join a chat");
        availableCommands.put("leave <channel id>", "Leave a chat");
        availableCommands.put("say <message>", "Sends message to currently joined channel");
        availableCommands.put("toggle chat", "Toggle messages appearing from the chat");
    }
}

