/*
 * Decompiled with CFR 0.152.
 */
package org.simonscode.telegrambots.framework;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.simonscode.telegrambots.framework.Bot;
import org.simonscode.telegrambots.framework.Controller;
import org.simonscode.telegrambots.framework.Module;
import org.simonscode.telegrambots.framework.State;

public class ModuleLoader {
    void loadModules(Bot bot) {
        for (Module module : ModuleLoader.scanModules()) {
            module.preLoad(bot);
            bot.enableModule(module);
        }
    }

    private static List<Module> scanModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        System.out.println("Scanning for modules...");
        File moduleDir = new File("modules");
        if (moduleDir.exists()) {
            File[] moduleList = moduleDir.listFiles(file -> file.getPath().toLowerCase().endsWith(".jar"));
            if (moduleList == null) {
                System.out.println("No modules found!\nShutting down...");
                Controller.stop();
                System.exit(0);
                return modules;
            }
            URL[] urls = (URL[])Arrays.stream(moduleList).map(file -> {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).toArray(URL[]::new);
            System.out.printf("Found %d files.\nLoading file%s...\n", urls.length, urls.length == 1 ? "" : "s");
            URLClassLoader ucl = new URLClassLoader(urls);
            ServiceLoader<Module> loader = ServiceLoader.load(Module.class, ucl);
            for (Module module : loader) {
                System.out.println("Loaded: " + module.getModuleInfo().getName());
                modules.add(module);
            }
        } else if (moduleDir.mkdirs()) {
            System.out.println("Module-Directory has been created.");
        } else {
            System.out.println("Unknown error creating modules directory");
        }
        return modules;
    }

    void loadModules(Bot bot, HashMap<String, State> modules) {
        for (Module module : ModuleLoader.scanModules()) {
            if (modules != null) {
                module.initialize(modules.get(module.getModuleInfo().getModuleId()));
            }
            module.preLoad(bot);
            bot.enableModule(module);
        }
    }
}

