/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.media.InputMedia;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendMediaGroup
extends PartialBotApiMethod<ArrayList<Message>> {
    public static final String PATH = "sendMediaGroup";
    public static final String CHATID_FIELD = "chat_id";
    public static final String MEDIA_FIELD = "media";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="media")
    private List<InputMedia> media;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;

    public SendMediaGroup() {
    }

    public SendMediaGroup(String chatId, List<InputMedia> media) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.media = Preconditions.checkNotNull(media);
    }

    public SendMediaGroup(Long chatId, List<InputMedia> media) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.media = Preconditions.checkNotNull(media);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendMediaGroup setChatId(String chatId) {
        this.chatId = Preconditions.checkNotNull(chatId);
        return this;
    }

    public SendMediaGroup setChatId(Long chatId) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendMediaGroup setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendMediaGroup enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendMediaGroup disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public List<InputMedia> getMedia() {
        return this.media;
    }

    public void setMedia(List<InputMedia> media) {
        this.media = media;
    }

    @Override
    public ArrayList<Message> deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<ArrayList<Message>>>(){});
            if (result.getOk().booleanValue()) {
                return (ArrayList)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending media group", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.media == null || this.media.isEmpty()) {
            throw new TelegramApiValidationException("Media parameter can't be empty", this);
        }
        for (InputMedia inputMedia : this.media) {
            inputMedia.validate();
        }
    }

    public String toString() {
        return "SendMediaGroup{chatId='" + this.chatId + '\'' + ", media=" + this.media + ", replyToMessageId=" + this.replyToMessageId + ", disableNotification=" + this.disableNotification + '}';
    }
}

