/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendVideoNote
extends PartialBotApiMethod<Message> {
    public static final String PATH = "sendvideonote";
    public static final String CHATID_FIELD = "chat_id";
    public static final String VIDEONOTE_FIELD = "video_note";
    public static final String DURATION_FIELD = "duration";
    public static final String LENGTH_FIELD = "length";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    private String chatId;
    private String videoNote;
    private Integer duration;
    private Integer length;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private boolean isNewVideoNote;
    private String videoNoteName;
    private File newVideoNoteFile;
    private InputStream newVideoNoteStream;

    public SendVideoNote() {
    }

    public SendVideoNote(String chatId, String videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.videoNote = Preconditions.checkNotNull(videoNote);
        this.isNewVideoNote = false;
    }

    public SendVideoNote(Long chatId, String videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.videoNote = Preconditions.checkNotNull(videoNote);
        this.isNewVideoNote = false;
    }

    public SendVideoNote(String chatId, File newVideoNoteFile) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.newVideoNoteFile = Preconditions.checkNotNull(newVideoNoteFile);
        this.isNewVideoNote = true;
    }

    public SendVideoNote(Integer chatId, File newVideoNoteFile) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.newVideoNoteFile = Preconditions.checkNotNull(newVideoNoteFile);
        this.isNewVideoNote = true;
    }

    public SendVideoNote(String chatId, String videoNoteName, InputStream newVideoNoteStream) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.videoNoteName = Preconditions.checkNotNull(videoNoteName);
        this.newVideoNoteStream = Preconditions.checkNotNull(newVideoNoteStream);
        this.isNewVideoNote = true;
    }

    public SendVideoNote(Integer chatId, String videoNoteName, InputStream newVideoNoteStream) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.videoNoteName = Preconditions.checkNotNull(videoNoteName);
        this.newVideoNoteStream = Preconditions.checkNotNull(newVideoNoteStream);
        this.isNewVideoNote = true;
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendVideoNote setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getVideoNote() {
        return this.videoNote;
    }

    public SendVideoNote setVideoNote(String videoNote) {
        this.videoNote = videoNote;
        this.isNewVideoNote = false;
        return this;
    }

    public Integer getLength() {
        return this.length;
    }

    public SendVideoNote setLength(Integer length) {
        this.length = length;
        return this;
    }

    public SendVideoNote setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public SendVideoNote setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendVideoNote setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendVideoNote setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendVideoNote enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendVideoNote disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public boolean isNewVideoNote() {
        return this.isNewVideoNote;
    }

    public SendVideoNote setNewVideoNote(File file) {
        this.isNewVideoNote = true;
        this.newVideoNoteFile = file;
        return this;
    }

    public SendVideoNote setNewVideo(String videoName, InputStream inputStream) {
        Objects.requireNonNull(videoName, "videoName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.videoNoteName = videoName;
        this.isNewVideoNote = true;
        this.newVideoNoteStream = inputStream;
        return this;
    }

    public String getVideoNoteName() {
        return this.videoNoteName;
    }

    public File getNewVideoNoteFile() {
        return this.newVideoNoteFile;
    }

    public InputStream getNewVideoNoteStream() {
        return this.newVideoNoteStream;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending video", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.isNewVideoNote) {
            if (this.newVideoNoteFile == null && this.newVideoNoteStream == null) {
                throw new TelegramApiValidationException("Videonote  can't be empty", this);
            }
            if (this.newVideoNoteStream != null && (this.videoNoteName == null || this.videoNoteName.isEmpty())) {
                throw new TelegramApiValidationException("Video note name can't be empty", this);
            }
        } else if (this.videoNote == null) {
            throw new TelegramApiValidationException("Video note can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "SendVideoNote{chatId='" + this.chatId + '\'' + ", videoNote='" + this.videoNote + '\'' + ", duration=" + this.duration + ", length=" + this.length + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", isNewVideoNote=" + this.isNewVideoNote + ", videoNoteName='" + this.videoNoteName + '\'' + ", newVideoNoteFile=" + this.newVideoNoteFile + ", newVideoNoteStream=" + this.newVideoNoteStream + '}';
    }
}

