/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.api.objects.stickers.StickerSet;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class GetStickerSet
extends BotApiMethod<StickerSet> {
    private static final String PATH = "getStickerSet";
    private static final String NAME_FIELD = "name";
    @JsonProperty(value="name")
    private String name;

    public GetStickerSet(String name) {
        this.name = Preconditions.checkNotNull(name);
    }

    public GetStickerSet() {
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public StickerSet deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<StickerSet>>(){});
            if (result.getOk().booleanValue()) {
                return (StickerSet)result.getResult();
            }
            throw new TelegramApiRequestException("Error getting sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("Name can't be null", this);
        }
    }

    public String getName() {
        return this.name;
    }

    public GetStickerSet setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return "GetStickerSet{name='" + this.name + '\'' + '}';
    }
}

