/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.payments;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.telegram.telegrambots.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.api.interfaces.Validable;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class LabeledPrice
implements InputBotApiObject,
Validable {
    private static final String LABEL_FIELD = "label";
    private static final String AMOUNT_FIELD = "amount";
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="amount")
    private Integer amount;

    public LabeledPrice() {
    }

    public LabeledPrice(String label, Integer amount) {
        this.label = Preconditions.checkNotNull(label);
        this.amount = Preconditions.checkNotNull(amount);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = Preconditions.checkNotNull(label);
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = Preconditions.checkNotNull(amount);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.label == null || this.label.isEmpty()) {
            throw new TelegramApiValidationException("Label parameter can't be empty", this);
        }
        if (this.amount == null) {
            throw new TelegramApiValidationException("Amount parameter can't be empty", this);
        }
    }

    public String toString() {
        return "LabeledPrice{label='" + this.label + '\'' + ", amount=" + this.amount + '}';
    }
}

