/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.lightningcsv;

import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.simpleflatmapper.lightningcsv.Row;
import org.simpleflatmapper.lightningcsv.impl.CellConsumerCapture;
import org.simpleflatmapper.lightningcsv.impl.CellConsumerFixLengthToCheckConsumer;
import org.simpleflatmapper.lightningcsv.parser.AbstractCharConsumer;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.lightningcsv.parser.CharBuffer;
import org.simpleflatmapper.lightningcsv.parser.NullCellConsumer;
import org.simpleflatmapper.lightningcsv.parser.StringArrayCellConsumer;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Function;

public final class CsvReader
implements Iterable<String[]> {
    private final AbstractCharConsumer consumer;
    private final Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper;

    public CsvReader(AbstractCharConsumer charConsumer) {
        this(charConsumer, null);
    }

    public CsvReader(AbstractCharConsumer charConsumer, Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper) {
        this.consumer = charConsumer;
        this.cellConsumerWrapper = cellConsumerWrapper;
    }

    public <CC extends CellConsumer> CC parseAll(CC cellConsumer) throws IOException {
        this._parseAll(this.wrapConsumer(cellConsumer), false);
        return cellConsumer;
    }

    private <CC extends CellConsumer> void _parseAll(CC cellConsumer, boolean keepRow) throws IOException {
        do {
            this.consumer.consumeAllBuffer(cellConsumer);
        } while (this.consumer.shiftAndRead(keepRow));
        this.consumer.finish(cellConsumer);
    }

    public boolean parseRow(CellConsumer cellConsumer) throws IOException {
        return this.rawParseRow(this.wrapConsumer(cellConsumer), false);
    }

    public boolean rawParseRow(CellConsumer cellConsumer, boolean keepRow) throws IOException {
        do {
            if (!this.consumer.consumeToNextRow(cellConsumer)) continue;
            return true;
        } while (this.consumer.shiftAndRead(keepRow));
        this.consumer.finish(cellConsumer);
        return false;
    }

    public void skipRows(int n) throws IOException {
        this._parseRows(NullCellConsumer.INSTANCE, n);
    }

    public <CC extends CellConsumer> CC parseRows(CC cellConsumer, int limit) throws IOException {
        this._parseRows(this.wrapConsumer(cellConsumer), limit);
        return cellConsumer;
    }

    private <CC extends CellConsumer> void _parseRows(CC cellConsumer, int limit) throws IOException {
        for (int i = 0; i < limit; ++i) {
            this.rawParseRow(cellConsumer, false);
        }
    }

    public <RH extends CheckedConsumer<String[]>> RH read(RH consumer) throws IOException {
        this.parseAll(this.toCellConsumer(consumer));
        return consumer;
    }

    public <RH extends CheckedConsumer<String[]>> RH read(RH consumer, int limit) throws IOException {
        this.parseRows(this.toCellConsumer(consumer), limit);
        return consumer;
    }

    private CellConsumer toCellConsumer(CheckedConsumer<String[]> consumer) {
        return StringArrayCellConsumer.newInstance(consumer);
    }

    public CellConsumer wrapConsumer(CellConsumer cellConsumer) {
        if (this.cellConsumerWrapper == null) {
            return cellConsumer;
        }
        return (CellConsumer)this.cellConsumerWrapper.apply((Object)cellConsumer);
    }

    public CharBuffer charBuffer() {
        return this.consumer.charBuffer();
    }

    @Override
    public Iterator<String[]> iterator() {
        return new CsvStringArrayIterator(this);
    }

    public Iterator<Row> rowIterator() throws IOException {
        return new CsvRowArrayIterator(this);
    }

    private static Row.Headers headers(CsvReader reader) throws IOException {
        CellConsumerCapture cellConsumer = new CellConsumerCapture();
        reader.parseRow(cellConsumer);
        if (!cellConsumer.hasData()) {
            throw new EOFException("No headers");
        }
        return Row.headers(cellConsumer.values());
    }

    private static class CsvRowArrayIterator
    implements Iterator<Row> {
        private final CsvReader reader;
        private final CellConsumerFixLengthToCheckConsumer cellConsumer;
        private Row.Headers headers;
        private Row value;
        private boolean isFetched;

        public CsvRowArrayIterator(CsvReader csvReader) throws IOException {
            this.reader = csvReader;
            this.headers = CsvReader.headers(csvReader);
            this.cellConsumer = new CellConsumerFixLengthToCheckConsumer(this.headers.size(), new Consumer<String[]>(){

                public void accept(String[] strings) {
                    CsvRowArrayIterator.this.value = new Row(CsvRowArrayIterator.this.headers, strings);
                }
            });
        }

        @Override
        public boolean hasNext() {
            this.fetch();
            return this.value != null;
        }

        private void fetch() {
            if (!this.isFetched) {
                try {
                    this.value = null;
                    this.reader.parseRow(this.cellConsumer);
                }
                catch (IOException e) {
                    ErrorHelper.rethrow((Throwable)e);
                }
                this.isFetched = true;
            }
        }

        @Override
        public Row next() {
            this.fetch();
            if (this.value == null) {
                throw new NoSuchElementException();
            }
            this.isFetched = false;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CsvStringArrayIterator
    implements Iterator<String[]> {
        private final CsvReader reader;
        private final CellConsumer cellConsumer;
        private boolean isFetched;
        private String[] value;

        public CsvStringArrayIterator(CsvReader csvReader) {
            this.cellConsumer = csvReader.toCellConsumer((CheckedConsumer<String[]>)((CheckedConsumer)new CheckedConsumer<String[]>(){

                public void accept(String[] strings) {
                    CsvStringArrayIterator.access$002(CsvStringArrayIterator.this, strings);
                }
            }));
            this.reader = csvReader;
        }

        @Override
        public boolean hasNext() {
            this.fetch();
            return this.value != null;
        }

        private void fetch() {
            if (!this.isFetched) {
                try {
                    this.value = null;
                    this.reader.parseRow(this.cellConsumer);
                }
                catch (IOException e) {
                    ErrorHelper.rethrow((Throwable)e);
                }
                this.isFetched = true;
            }
        }

        @Override
        public String[] next() {
            this.fetch();
            if (this.value == null) {
                throw new NoSuchElementException();
            }
            this.isFetched = false;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ String[] access$002(CsvStringArrayIterator x0, String[] x1) {
            x0.value = x1;
            return x1;
        }
    }
}

