/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.test;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.converter.ConvertingTypes;

public class ConvertingTypesTest {
    @Test
    public void testScoreExactMatch() {
        ConvertingTypes stringToDate = new ConvertingTypes(String.class, Date.class);
        ConvertingTypes dateToString = new ConvertingTypes(Date.class, String.class);
        Assert.assertEquals((long)256L, (long)stringToDate.score(stringToDate).getFromScore());
        Assert.assertEquals((long)256L, (long)stringToDate.score(stringToDate).getToScore());
        Assert.assertEquals((long)65792L, (long)stringToDate.score(stringToDate).getScore());
        Assert.assertEquals((long)65792L, (long)dateToString.score(dateToString).getScore());
        Assert.assertEquals((long)-1L, (long)stringToDate.score(dateToString).getScore());
        Assert.assertEquals((long)-1L, (long)dateToString.score(stringToDate).getScore());
    }

    @Test
    public void testTestScoreHierarchyFrom() {
        ConvertingTypes objectToByte = new ConvertingTypes(Object.class, Byte.class);
        ConvertingTypes numberToByte = new ConvertingTypes(Number.class, Byte.class);
        ConvertingTypes longToByte = new ConvertingTypes(Long.class, Byte.class);
        Assert.assertTrue((objectToByte.score(longToByte).getScore() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numberToByte.score(longToByte).getScore() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((numberToByte.score(longToByte).getScore() < longToByte.score(longToByte).getScore() ? 1 : 0) != 0);
        Assert.assertTrue((objectToByte.score(longToByte).getScore() < numberToByte.score(longToByte).getScore() ? 1 : 0) != 0);
    }

    @Test
    public void testTestScoreHierarchyTo() {
        ConvertingTypes objectToNumber = new ConvertingTypes(Object.class, Number.class);
        ConvertingTypes objectToLong = new ConvertingTypes(Object.class, Long.class);
        ConvertingTypes objectToObject = new ConvertingTypes(Object.class, Object.class);
        Assert.assertTrue((objectToObject.score(objectToNumber).getScore() < 0 ? 1 : 0) != 0);
        Assert.assertTrue((objectToNumber.score(objectToNumber).getScore() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((objectToLong.score(objectToNumber).getScore() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((objectToNumber.score(objectToNumber).getScore() > objectToNumber.score(objectToLong).getScore() ? 1 : 0) != 0);
    }

    @Test
    public void testCharSequenceEnum() {
        ConvertingTypes csToEnum = new ConvertingTypes(CharSequence.class, Enum.class);
        ConvertingTypes stringToEnum = new ConvertingTypes(Object.class, Long.class);
    }
}

