/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.test;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.UncheckedConverterHelper;

public class UncheckedConverterHelperTest {
    @Test
    public void testUncheckConverterFail() {
        Converter<Object, Object> converter = new Converter<Object, Object>(){

            public Object convert(Object in) throws IOException {
                throw new IOException("What!");
            }
        };
        try {
            this.convertUncheck(converter);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
    }

    @Test
    public void testUncheckConverterWorj() {
        Converter<Object, Object> converter = new Converter<Object, Object>(){

            public Object convert(Object in) throws IOException {
                return "Ok!";
            }
        };
        Assert.assertEquals((Object)"Ok!", (Object)UncheckedConverterHelper.toUnchecked((Converter)converter).convert(null));
    }

    private void convertUncheck(Converter<Object, Object> converter) {
        UncheckedConverterHelper.toUnchecked(converter).convert(null);
    }
}

