/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.test;

import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.converter.ComposedConverter;
import org.simpleflatmapper.converter.ConversionException;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.converter.ToStringConverter;
import org.simpleflatmapper.converter.impl.CharSequenceIntegerConverter;
import org.simpleflatmapper.converter.test.ConverterServiceTestHelper;
import org.simpleflatmapper.util.date.DateFormatSupplier;

public class ConverterServiceTest {
    @Test
    public void testToStringConverter() throws Exception {
        ConverterServiceTestHelper.testConverter("Hoy", "Hoy", Object.class, String.class, new Object[0]);
    }

    @Test
    public void testNumberToNumberConverter() throws Exception {
        ConverterServiceTestHelper.testConverter(13, (byte)13);
        ConverterServiceTestHelper.testConverter((byte)13, 13);
        ConverterServiceTestHelper.testConverter(13, (short)13);
        ConverterServiceTestHelper.testConverter((short)13, 13);
        ConverterServiceTestHelper.testConverter(13, 13);
        ConverterServiceTestHelper.testConverter(13, 13);
        ConverterServiceTestHelper.testConverter(13, 13L);
        ConverterServiceTestHelper.testConverter(13L, 13);
        ConverterServiceTestHelper.testConverter(13, Float.valueOf(13.0f));
        ConverterServiceTestHelper.testConverter(Float.valueOf(13.0f), 13);
        ConverterServiceTestHelper.testConverter(13, 13.0);
        ConverterServiceTestHelper.testConverter(13.0, 13);
        ConverterServiceTestHelper.testConverter(13, new BigDecimal(13));
        ConverterServiceTestHelper.testConverter(new BigDecimal(13), 13);
        ConverterServiceTestHelper.testConverter(new BigInteger("13"), new BigDecimal("13"));
        ConverterServiceTestHelper.testConverter(13, new BigInteger("13"));
        ConverterServiceTestHelper.testConverter(new BigDecimal("13"), new BigInteger("13"));
        ConverterServiceTestHelper.testConverter(new BigInteger("13"), 13);
    }

    @Test
    public void testChain2Converters() throws Exception {
        ConverterServiceTestHelper.testConverter("1", BigDecimal.ONE);
    }

    @Test
    public void testObjectToEnumConverter() throws Exception {
        ConverterServiceTestHelper.testConverter(0, ENUM.type1, Object.class, ENUM.class, new Object[0]);
        ConverterServiceTestHelper.testConverter("type2", ENUM.type2, Object.class, ENUM.class, new Object[0]);
        ConverterServiceTestHelper.testConverter(null, null, Object.class, ENUM.class, new Object[0]);
    }

    @Test
    public void testNumberToEnumConverter() throws Exception {
        ConverterServiceTestHelper.testConverter(0, ENUM.type1);
        ConverterServiceTestHelper.testConverter(1, ENUM.type2);
        ConverterServiceTestHelper.testConverter(null, null, Number.class, ENUM.class, new Object[0]);
        try {
            ConverterServiceTestHelper.testConverter(2, ENUM.type2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIdentity() throws Exception {
        Object o = new Object();
        ConverterServiceTestHelper.testConverter(o, o);
    }

    @Test
    public void testURLConverter() throws Exception {
        ConverterServiceTestHelper.testConverter("http://url.net", new URL("http://url.net"));
        try {
            ConverterService.getInstance().findConverter(String.class, URL.class, new Object[0]).convert((Object)"blop");
            Assert.fail();
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test
    public void testCharSequenceConverter() throws Exception {
        ConverterServiceTestHelper.testConverter(new StringBuilder("hello"), "hello");
        ConverterServiceTestHelper.testConverter("123", (byte)123);
        ConverterServiceTestHelper.testConverter("123", Character.valueOf('{'));
        ConverterServiceTestHelper.testConverter("1234", (short)1234);
        ConverterServiceTestHelper.testConverter("1234", 1234);
        ConverterServiceTestHelper.testConverter("1234", 1234L);
        ConverterServiceTestHelper.testConverter("1234.56", Float.valueOf(1234.56f));
        ConverterServiceTestHelper.testConverter("1234.56", 1234.56);
        ConverterServiceTestHelper.testConverter("type2", ENUM.type2);
        ConverterServiceTestHelper.testConverter("20170607", new SimpleDateFormat("yyyyMMdd").parse("20170607"), CharSequence.class, Date.class, new DateFormatSupplier(){

            public String get() {
                return "yyyyMMdd";
            }
        });
        ConverterServiceTestHelper.testConverter("false", Boolean.FALSE);
        ConverterServiceTestHelper.testConverter("true", Boolean.TRUE);
        ConverterServiceTestHelper.testConverter("123456789101112", new BigInteger("123456789101112"));
        ConverterServiceTestHelper.testConverter("123456789101112.0123456", new BigDecimal("123456789101112.0123456"));
        UUID uuid = UUID.randomUUID();
        ConverterServiceTestHelper.testConverter(uuid.toString(), uuid);
    }

    @Test
    public void testNoConverter() {
        Assert.assertNull((Object)ConverterService.getInstance().findConverter(Reader.class, System.class, new Object[0]));
    }

    @Test
    public void testListToNumberSOE() {
        ConverterService converterService = ConverterService.getInstance();
        Converter converter = converterService.findConverter(List.class, Integer.class, new Object[0]);
        Assert.assertTrue((boolean)(converter instanceof ComposedConverter));
        ComposedConverter composedConverter = (ComposedConverter)converter;
        Assert.assertTrue((boolean)(composedConverter.c1 instanceof ToStringConverter));
        Assert.assertTrue((boolean)(composedConverter.c2 instanceof CharSequenceIntegerConverter));
    }

    public static enum ENUM {
        type1,
        type2;

    }
}

