/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.converter.ComposedConverter;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterFactory;
import org.simpleflatmapper.converter.ConverterFactoryProducer;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.converter.impl.IdentityConverter;
import org.simpleflatmapper.converter.impl.JavaBaseConverterFactoryProducer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ProducerServiceLoader;
import org.simpleflatmapper.util.TypeHelper;

public class ConverterService {
    private static final ConverterService INSTANCE = new ConverterService(ConverterService.getConverterFactories());
    private final List<ConverterFactory> converters;

    private static List<ConverterFactory> getConverterFactories() {
        final ArrayList<ConverterFactory> converterFactories = new ArrayList<ConverterFactory>();
        Consumer factoryConsumer = new Consumer<ConverterFactory<?, ?>>(){

            public void accept(ConverterFactory<?, ?> converterFactory) {
                converterFactories.add(converterFactory);
            }
        };
        new JavaBaseConverterFactoryProducer().produce(factoryConsumer);
        ProducerServiceLoader.produceFromServiceLoader(ConverterFactoryProducer.class, (Consumer)factoryConsumer);
        return converterFactories;
    }

    public static ConverterService getInstance() {
        return INSTANCE;
    }

    private ConverterService(List<ConverterFactory> converters) {
        this.converters = converters;
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Class<F> inType, Class<P> outType, Object ... params) {
        return this.findConverter((Type)inType, (Type)outType, params);
    }

    public <F, P> Converter<? super F, ? extends P> findConverter(Type inType, Type outType, Object ... params) {
        ArrayList<ScoredConverterFactory> potentials = new ArrayList<ScoredConverterFactory>();
        ArrayList<ScoredConverterFactory> tails = new ArrayList<ScoredConverterFactory>();
        if (TypeHelper.isAssignable((Type)outType, (Type)inType)) {
            return new IdentityConverter();
        }
        ConvertingTypes targetedTypes = new ConvertingTypes(inType, outType);
        for (ConverterFactory converterFactory : this.converters) {
            ConvertingScore score = converterFactory.score(targetedTypes);
            int globalScore = score.getScore();
            if (globalScore >= 0) {
                potentials.add(new ScoredConverterFactory(globalScore, converterFactory));
                continue;
            }
            int tailScore = score.getToScore();
            if (tailScore < 0) continue;
            tails.add(new ScoredConverterFactory(tailScore, converterFactory));
        }
        if (potentials.size() > 0) {
            Collections.sort(potentials);
            for (ScoredConverterFactory p : potentials) {
                Converter converter = p.converterFactory.newConverter(targetedTypes, params);
                if (converter == null) continue;
                return converter;
            }
            return null;
        }
        if (tails.size() > 0) {
            Collections.sort(tails);
            ComposedConverter composedConverter = null;
            int currentScore = 0;
            for (ScoredConverterFactory sfactory : tails) {
                Converter tailConverter;
                Converter<F, P> headConverter;
                if (composedConverter != null && currentScore > sfactory.score) {
                    return composedConverter;
                }
                Type tailFactoryInType = sfactory.converterFactory.getFromType();
                if (outType == tailFactoryInType || (headConverter = this.findConverter(inType, tailFactoryInType, params)) == null || (tailConverter = sfactory.converterFactory.newConverter(new ConvertingTypes(tailFactoryInType, targetedTypes.getTo()), params)) == null) continue;
                ComposedConverter c = new ComposedConverter(headConverter, tailConverter);
                if (composedConverter != null && c.depth() >= composedConverter.depth()) continue;
                composedConverter = c;
            }
            return composedConverter;
        }
        return null;
    }

    private static class ScoredConverterFactory
    implements Comparable<ScoredConverterFactory> {
        private final int score;
        private final ConverterFactory converterFactory;

        private ScoredConverterFactory(int score, ConverterFactory converterFactory) {
            this.score = score;
            this.converterFactory = converterFactory;
        }

        @Override
        public int compareTo(ScoredConverterFactory o) {
            return o.score - this.score;
        }
    }
}

