/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.time;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.converter.test.ConverterServiceTestHelper;

public class JavaTimeConverterServiceTest {
    @Test
    public void testJavaTimeToDate() throws Exception {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        ConverterServiceTestHelper.testConverter(localDateTime, date);
        ConverterServiceTestHelper.testConverter(localDateTime.toLocalTime(), date);
        ConverterServiceTestHelper.testConverter(localDateTime.toLocalDate(), this.trunc(date));
        ConverterServiceTestHelper.testConverter(date.toInstant(), date);
        ConverterServiceTestHelper.testConverter(zonedDateTime, date);
        ConverterServiceTestHelper.testConverter(zonedDateTime.toOffsetDateTime(), date);
        ConverterServiceTestHelper.testConverter(zonedDateTime.toOffsetDateTime().toOffsetTime(), date);
        ConverterServiceTestHelper.testConverter(YearMonth.of(2016, Month.FEBRUARY), new SimpleDateFormat("yyyyMMdd").parse("20160201"));
        ConverterServiceTestHelper.testConverter(Year.of(2016), new SimpleDateFormat("yyyyMMdd").parse("20160101"));
    }

    @Test
    public void testDateToJavaTime() throws Exception {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        ConverterServiceTestHelper.testConverter(date, localDateTime);
        ConverterServiceTestHelper.testConverter(date, localDateTime.toLocalTime());
        ConverterServiceTestHelper.testConverter(this.trunc(date), localDateTime.toLocalDate());
        ConverterServiceTestHelper.testConverter(date, date.toInstant());
        ConverterServiceTestHelper.testConverter(date, zonedDateTime);
        ConverterServiceTestHelper.testConverter(date, zonedDateTime.toOffsetDateTime());
        ConverterServiceTestHelper.testConverter(date, zonedDateTime.toOffsetDateTime().toOffsetTime());
        ConverterServiceTestHelper.testConverter(new SimpleDateFormat("yyyyMMdd").parse("20160201"), YearMonth.of(2016, Month.FEBRUARY));
        ConverterServiceTestHelper.testConverter(new SimpleDateFormat("yyyyMMdd").parse("20160201"), Year.of(2016));
    }

    @Test
    public void testObjectToInstant() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = Instant.now();
        this.testObjectToInstant(null, null);
        this.testObjectToInstant(instant, instant);
        this.testObjectToInstant(instant.atZone(zoneId), instant);
        this.testObjectToInstant(instant.atZone(zoneId).toInstant(), instant);
        this.testObjectToInstant(instant.atZone(zoneId).toLocalDateTime(), instant);
        this.testObjectToInstant(instant.atZone(zoneId).toOffsetDateTime(), instant);
        this.testObjectToInstant(Date.from(instant), instant.truncatedTo(ChronoUnit.MILLIS));
        this.testObjectToInstant(instant.toEpochMilli(), instant.truncatedTo(ChronoUnit.MILLIS));
        try {
            this.testObjectToInstant("a string", instant);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToInstant(Object in, Instant out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, Instant.class);
    }

    @Test
    public void testObjectToLocalDate() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = LocalDate.now(zoneId);
        this.testObjectToLocalDate(null, null);
        this.testObjectToLocalDate(localDate, localDate);
        this.testObjectToLocalDate(localDate.atStartOfDay().atZone(zoneId), localDate);
        this.testObjectToLocalDate(localDate.atStartOfDay().atZone(zoneId).toInstant(), localDate);
        this.testObjectToLocalDate(localDate.atStartOfDay().atZone(zoneId).toOffsetDateTime(), localDate);
        this.testObjectToLocalDate(localDate.atStartOfDay(), localDate);
        this.testObjectToLocalDate(Date.from(localDate.atStartOfDay().atZone(zoneId).toInstant()), localDate);
        try {
            this.testObjectToLocalDate("a string", localDate);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToLocalDate(Object in, LocalDate out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, LocalDate.class);
    }

    @Test
    public void testObjectToLocalDateTime() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.now(zoneId);
        this.testObjectToLocalDateTime(null, null);
        this.testObjectToLocalDateTime(localDateTime, localDateTime);
        this.testObjectToLocalDateTime(localDateTime.atZone(zoneId), localDateTime);
        this.testObjectToLocalDateTime(localDateTime.atZone(zoneId).toInstant(), localDateTime);
        this.testObjectToLocalDateTime(localDateTime.atZone(zoneId).toOffsetDateTime(), localDateTime);
        this.testObjectToLocalDateTime(Date.from(localDateTime.atZone(zoneId).toInstant()), localDateTime.truncatedTo(ChronoUnit.MILLIS));
        try {
            this.testObjectToLocalDateTime("a string", localDateTime);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToLocalDateTime(Object in, LocalDateTime out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, LocalDateTime.class);
    }

    @Test
    public void testObjectToLocalTime() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalTime localTime = LocalTime.now(zoneId);
        ZoneOffset offset = zoneId.getRules().getOffset(localTime.atDate(LocalDate.now()));
        this.testObjectToLocalTime(null, null);
        this.testObjectToLocalTime(localTime, localTime);
        this.testObjectToLocalTime(localTime.atDate(LocalDate.now()), localTime);
        this.testObjectToLocalTime(localTime.atDate(LocalDate.now()).atZone(zoneId), localTime);
        this.testObjectToLocalTime(localTime.atDate(LocalDate.now()).atOffset(offset), localTime);
        this.testObjectToLocalTime(localTime.atDate(LocalDate.now()).toLocalTime(), localTime);
        this.testObjectToLocalTime(localTime.atDate(LocalDate.now()).toInstant(offset), localTime);
        this.testObjectToLocalTime(Date.from(localTime.atDate(LocalDate.now()).toInstant(offset)), localTime.truncatedTo(ChronoUnit.MILLIS));
        try {
            this.testObjectToLocalTime("a string", localTime);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToLocalTime(Object in, LocalTime out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, LocalTime.class);
    }

    @Test
    public void testObjectToOffsetDateTime() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        OffsetDateTime offsetDateTime = OffsetDateTime.now(zoneId);
        this.testObjectToOffsetDateTime(null, null);
        this.testObjectToOffsetDateTime(offsetDateTime, offsetDateTime);
        this.testObjectToOffsetDateTime(offsetDateTime.toLocalDateTime(), offsetDateTime);
        this.testObjectToOffsetDateTime(offsetDateTime.toInstant(), offsetDateTime);
        this.testObjectToOffsetDateTime(offsetDateTime.atZoneSameInstant(zoneId), offsetDateTime);
        this.testObjectToOffsetDateTime(offsetDateTime.atZoneSameInstant(zoneId), offsetDateTime);
        this.testObjectToOffsetDateTime(offsetDateTime.toLocalDate(), offsetDateTime.truncatedTo(ChronoUnit.DAYS));
        this.testObjectToOffsetDateTime(Date.from(offsetDateTime.toInstant()), offsetDateTime.truncatedTo(ChronoUnit.MILLIS));
        try {
            this.testObjectToOffsetDateTime("a string", offsetDateTime);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToOffsetDateTime(Object in, OffsetDateTime out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, OffsetDateTime.class);
    }

    @Test
    public void testObjectToOffsetTime() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        OffsetTime offsetTime = OffsetTime.now(zoneId);
        this.testObjectToOffsetTime(null, null);
        this.testObjectToOffsetTime(offsetTime, offsetTime);
        this.testObjectToOffsetTime(offsetTime.atDate(LocalDate.now()), offsetTime);
        this.testObjectToOffsetTime(offsetTime.atDate(LocalDate.now()).atZoneSimilarLocal(zoneId), offsetTime);
        this.testObjectToOffsetTime(offsetTime.atDate(LocalDate.now()).toLocalDateTime(), offsetTime);
        this.testObjectToOffsetTime(offsetTime.atDate(LocalDate.now()).toLocalTime(), offsetTime);
        this.testObjectToOffsetTime(offsetTime.atDate(LocalDate.now()).toInstant(), offsetTime);
        this.testObjectToOffsetTime(Date.from(offsetTime.atDate(LocalDate.now()).toInstant()), offsetTime.truncatedTo(ChronoUnit.MILLIS));
        try {
            this.testObjectToOffsetTime("a string", offsetTime);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToOffsetTime(Object in, OffsetTime out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, OffsetTime.class);
    }

    @Test
    public void testObjectToYear() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        Date now = new Date();
        Year year = Year.from(now.toInstant().atZone(zoneId));
        this.testObjectToYear(null, null);
        this.testObjectToYear(year, year);
        this.testObjectToYear(year.atMonth(6).atEndOfMonth().atTime(1, 0).atZone(zoneId), year);
        this.testObjectToYear(now, year);
        this.testObjectToYear(year.getValue(), year);
        try {
            this.testObjectToYear("a string", year);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToYear(Object in, Year out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, Year.class);
    }

    @Test
    public void testObjectToYearMonth() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        Date now = new Date();
        YearMonth yearMonth = YearMonth.from(now.toInstant().atZone(zoneId));
        this.testObjectToYearMonth(null, null);
        this.testObjectToYearMonth(yearMonth, yearMonth);
        this.testObjectToYearMonth(yearMonth.atEndOfMonth().atTime(1, 0).atZone(zoneId), yearMonth);
        this.testObjectToYearMonth(now, yearMonth);
        this.testObjectToYearMonth(yearMonth.getYear() * 100 + yearMonth.getMonthValue(), yearMonth);
        try {
            this.testObjectToYearMonth("a string", yearMonth);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToYearMonth(Object in, YearMonth out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, YearMonth.class);
    }

    @Test
    public void testObjectToZonedDateTime() throws Exception {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneId);
        this.testObjectToZonedDateTime(null, null);
        this.testObjectToZonedDateTime(zonedDateTime, zonedDateTime);
        this.testObjectToZonedDateTime(zonedDateTime.toInstant(), zonedDateTime);
        this.testObjectToZonedDateTime(zonedDateTime.toLocalDateTime(), zonedDateTime);
        this.testObjectToZonedDateTime(zonedDateTime.toOffsetDateTime(), zonedDateTime);
        this.testObjectToZonedDateTime(Date.from(zonedDateTime.toInstant()), zonedDateTime.truncatedTo(ChronoUnit.MILLIS));
        try {
            this.testObjectToZonedDateTime("a string", zonedDateTime);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testObjectToZonedDateTime(Object in, ZonedDateTime out) throws Exception {
        ConverterServiceTestHelper.testConverter(in, out, Object.class, ZonedDateTime.class);
    }

    @Test
    public void testCharacterToTime() throws Exception {
        this.testConvertFromCharSequence(Instant.now(), DateTimeFormatter.ISO_INSTANT);
        this.testConvertFromCharSequence(LocalDate.now(), DateTimeFormatter.ISO_LOCAL_DATE);
        this.testConvertFromCharSequence(LocalDateTime.now(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        this.testConvertFromCharSequence(LocalTime.now(), DateTimeFormatter.ISO_LOCAL_TIME);
        this.testConvertFromCharSequence(OffsetDateTime.now(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.testConvertFromCharSequence(OffsetTime.now(), DateTimeFormatter.ISO_OFFSET_TIME);
        this.testConvertFromCharSequence(Year.now(), DateTimeFormatter.ofPattern("yyyy"));
        this.testConvertFromCharSequence(YearMonth.now(), DateTimeFormatter.ofPattern("yyyy-MM"));
        this.testConvertFromCharSequence(ZonedDateTime.now(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public void testConvertFromCharSequence(Temporal temploral, DateTimeFormatter dateTimeFormatter) throws Exception {
        Converter converter = ConverterService.getInstance().findConverter(CharSequence.class, temploral.getClass(), new Object[]{dateTimeFormatter});
        Assert.assertEquals((Object)temploral, (Object)converter.convert((Object)dateTimeFormatter.format(temploral)));
        Assert.assertNull((Object)converter.convert((Object)""));
        Assert.assertNull((Object)converter.convert(null));
        DateTimeFormatter failing = DateTimeFormatter.ofPattern("yyyy////dd");
        Converter multiConverter = ConverterService.getInstance().findConverter(CharSequence.class, temploral.getClass(), new Object[]{failing, dateTimeFormatter});
        Assert.assertEquals((Object)temploral, (Object)multiConverter.convert((Object)dateTimeFormatter.format(temploral)));
        try {
            multiConverter.convert((Object)"a");
            Assert.fail();
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTemporalToString() throws Exception {
        Converter converter = ConverterService.getInstance().findConverter(ZonedDateTime.class, CharSequence.class, new Object[]{DateTimeFormatter.ISO_ZONED_DATE_TIME});
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Assert.assertEquals((Object)DateTimeFormatter.ISO_ZONED_DATE_TIME.format(zonedDateTime), (Object)converter.convert((Object)zonedDateTime));
    }

    @Test
    public void testTemporalToStringNoFormat() throws Exception {
        Converter converter = ConverterService.getInstance().findConverter(ZonedDateTime.class, CharSequence.class, new Object[0]);
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Assert.assertEquals((Object)zonedDateTime.toString(), (Object)converter.convert((Object)zonedDateTime));
    }

    private Date trunc(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }
}

