/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.converter.impl.time.JavaTimeHelper;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.date.DateFormatSupplier;
import org.simpleflatmapper.util.date.DefaultDateFormatSupplier;

public class JavaTimeHelperTest {
    public static final ZoneId ZONE_ID_CHICAGO = ZoneId.of("America/Chicago");
    public static final ZoneId ZONE_ID_NY = ZoneId.of("America/New_York");
    public static final TimeZone TIME_ZONE_NY = TimeZone.getTimeZone("America/New_York");
    public static final ZoneId ZONE_ID = ZoneId.of("America/Chicago");
    public static final Supplier<DateTimeFormatter> DATE_TIME_FORMATTER_SUPPLIER = new Supplier<DateTimeFormatter>(){

        public DateTimeFormatter get() {
            return DateTimeFormatter.ofPattern("MMddyyyy");
        }
    };
    public static final Supplier<DateTimeFormatter> DATE_TIME_FORMATTER_WITH_TZ_SUPPLIER = new Supplier<DateTimeFormatter>(){

        public DateTimeFormatter get() {
            return DateTimeFormatter.ofPattern("ddMMyyyy").withZone(ZONE_ID);
        }
    };
    public static final Supplier<TimeZone> TIME_ZONE_SUPPLIER = new Supplier<TimeZone>(){

        public TimeZone get() {
            return TIME_ZONE_NY;
        }
    };
    public static final Supplier<ZoneId> ZONE_ID_SUPPLIER = new Supplier<ZoneId>(){

        public ZoneId get() {
            return ZoneId.of("America/Chicago");
        }
    };

    @Test
    public void testGetFormattersFailWhenEmpty() {
        try {
            JavaTimeHelper.getDateTimeFormatters((Object[])new Object[0]);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFormatterReturnNullWhenEmpty() {
        Assert.assertNull((Object)JavaTimeHelper.getDateTimeFormatter((Object[])new Object[0]));
    }

    @Test
    public void testGetFormatterAndDefaultFormat() {
        Assert.assertEquals((Object)"Value(YearOfEra,4,19,EXCEEDS_PAD)", (Object)JavaTimeHelper.getDateTimeFormatter((Object[])new Object[]{new DefaultDateFormatSupplier(){

            public String get() {
                return "yyyy";
            }
        }}).toString());
        Assert.assertEquals((Object)DateTimeFormatter.ISO_DATE, (Object)JavaTimeHelper.getDateTimeFormatter((Object[])new Object[]{new DefaultDateFormatSupplier(){

            public String get() {
                return "yyyy";
            }
        }, DateTimeFormatter.ISO_DATE}));
    }

    @Test
    public void testGetFormattersAndDefaultFormat() {
        Assert.assertEquals((Object)"Value(YearOfEra,4,19,EXCEEDS_PAD)", (Object)JavaTimeHelper.getDateTimeFormatters((Object[])new Object[]{new DefaultDateFormatSupplier(){

            public String get() {
                return "yyyy";
            }
        }})[0].toString());
        Assert.assertArrayEquals((Object[])new DateTimeFormatter[]{DateTimeFormatter.ISO_DATE}, (Object[])JavaTimeHelper.getDateTimeFormatters((Object[])new Object[]{new DefaultDateFormatSupplier(){

            public String get() {
                return "yyyy";
            }
        }, DateTimeFormatter.ISO_DATE}));
    }

    @Test
    public void testFormattersFromString() {
        DateTimeFormatter[] yyyyMMdd = JavaTimeHelper.getDateTimeFormatters((Object[])new Object[]{new DateFormatSupplier(){

            public String get() {
                return "yyyyMMdd";
            }
        }});
        Assert.assertEquals((Object)DateTimeFormatter.ofPattern("yyyyMMdd").toString(), (Object)yyyyMMdd[0].toString());
        Assert.assertEquals((Object)ZoneId.systemDefault(), (Object)yyyyMMdd[0].getZone());
    }

    @Test
    public void testFormattersFromFormatter() {
        DateTimeFormatter[] yyyyMMdd = JavaTimeHelper.getDateTimeFormatters((Object[])new Object[]{DATE_TIME_FORMATTER_SUPPLIER});
        Assert.assertEquals((Object)DateTimeFormatter.ofPattern("MMddyyyy").toString(), (Object)yyyyMMdd[0].toString());
        Assert.assertEquals((Object)ZoneId.systemDefault(), (Object)yyyyMMdd[0].getZone());
    }

    @Test
    public void testFormattersFromFormatterWithOwnTZ() {
        DateTimeFormatter[] yyyyMMdd = JavaTimeHelper.getDateTimeFormatters((Object[])new Object[]{DATE_TIME_FORMATTER_WITH_TZ_SUPPLIER});
        Assert.assertEquals((Object)DateTimeFormatter.ofPattern("ddMMyyyy").toString(), (Object)yyyyMMdd[0].toString());
        Assert.assertEquals((Object)ZoneId.of("America/Chicago"), (Object)yyyyMMdd[0].getZone());
    }

    @Test
    public void testFormattersFromFormatterWithSpecifiedTZ() {
        DateTimeFormatter[] yyyyMMdd = JavaTimeHelper.getDateTimeFormatters((Object[])new Object[]{DATE_TIME_FORMATTER_WITH_TZ_SUPPLIER, TIME_ZONE_SUPPLIER});
        Assert.assertEquals((Object)DateTimeFormatter.ofPattern("ddMMyyyy").toString(), (Object)yyyyMMdd[0].toString());
        Assert.assertEquals((Object)ZoneId.of("America/New_York"), (Object)yyyyMMdd[0].getZone());
    }

    @Test
    public void testGetZoneIdDefault() {
        Assert.assertEquals((Object)ZoneId.systemDefault(), (Object)JavaTimeHelper.getZoneIdOrDefault((Object[])new Object[0]));
    }

    @Test
    public void testGetZoneIdFromTimeZone() {
        Assert.assertEquals((Object)ZONE_ID_NY, (Object)JavaTimeHelper.getZoneIdOrDefault((Object[])new Object[]{TIME_ZONE_SUPPLIER}));
    }

    @Test
    public void testGetZoneIdFromZoneId() {
        Assert.assertEquals((Object)ZONE_ID_CHICAGO, (Object)JavaTimeHelper.getZoneIdOrDefault((Object[])new Object[]{ZONE_ID_SUPPLIER}));
    }

    @Test
    public void testGetDateTimeZoneFromParams() {
        Assert.assertEquals((Object)ZONE_ID_NY, (Object)JavaTimeHelper.getZoneIdOrDefault((Object[])new Object[]{TIME_ZONE_SUPPLIER}));
        Assert.assertEquals((Object)ZONE_ID_CHICAGO, (Object)JavaTimeHelper.getZoneIdOrDefault((Object[])new Object[]{ZONE_ID_SUPPLIER}));
        Assert.assertEquals((Object)ZONE_ID_CHICAGO, (Object)JavaTimeHelper.getZoneIdOrDefault((Object[])new Object[]{TimeZone.getTimeZone("America/Chicago")}));
        Assert.assertEquals((Object)ZONE_ID_CHICAGO, (Object)JavaTimeHelper.getZoneIdOrDefault((Object[])new Object[]{ZONE_ID_CHICAGO}));
    }
}

