/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.simpleflatmapper.csv.Row;
import org.simpleflatmapper.csv.impl.CellConsumerCapture;
import org.simpleflatmapper.csv.impl.CellConsumerFixLengthToCheckConsumer;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CharConsumer;
import org.simpleflatmapper.csv.parser.NullCellConsumer;
import org.simpleflatmapper.csv.parser.StringArrayCellConsumer;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Function;

public final class CsvReader
implements Iterable<String[]> {
    private final CharConsumer consumer;
    private final Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper;

    public CsvReader(CharConsumer charConsumer) {
        this(charConsumer, null);
    }

    public CsvReader(CharConsumer charConsumer, Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper) {
        this.consumer = charConsumer;
        this.cellConsumerWrapper = cellConsumerWrapper;
    }

    public <CC extends CellConsumer> CC parseAll(CC cellConsumer) throws IOException {
        this._parseAll(this.wrapConsumer(cellConsumer));
        return cellConsumer;
    }

    private <CC extends CellConsumer> void _parseAll(CC cellConsumer) throws IOException {
        do {
            this.consumer.consumeAllBuffer(cellConsumer);
        } while (this.consumer.next());
        this.consumer.finish(cellConsumer);
    }

    public boolean parseRow(CellConsumer cellConsumer) throws IOException {
        return this._parseRow(this.wrapConsumer(cellConsumer));
    }

    private boolean _parseRow(CellConsumer cellConsumer) throws IOException {
        do {
            if (!this.consumer.consumeToNextRow(cellConsumer)) continue;
            return true;
        } while (this.consumer.next());
        this.consumer.finish(cellConsumer);
        return false;
    }

    public void skipRows(int n) throws IOException {
        this._parseRows(NullCellConsumer.INSTANCE, n);
    }

    public <CC extends CellConsumer> CC parseRows(CC cellConsumer, int limit) throws IOException {
        this._parseRows(this.wrapConsumer(cellConsumer), limit);
        return cellConsumer;
    }

    private <CC extends CellConsumer> void _parseRows(CC cellConsumer, int limit) throws IOException {
        for (int i = 0; i < limit; ++i) {
            this._parseRow(cellConsumer);
        }
    }

    public <RH extends CheckedConsumer<String[]>> RH read(RH consumer) throws IOException {
        this.parseAll(this.toCellConsumer(consumer));
        return consumer;
    }

    public <RH extends CheckedConsumer<String[]>> RH read(RH consumer, int limit) throws IOException {
        this.parseRows(this.toCellConsumer(consumer), limit);
        return consumer;
    }

    private CellConsumer toCellConsumer(CheckedConsumer<String[]> consumer) {
        return StringArrayCellConsumer.newInstance(consumer);
    }

    private CellConsumer wrapConsumer(CellConsumer cellConsumer) {
        if (this.cellConsumerWrapper == null) {
            return cellConsumer;
        }
        return (CellConsumer)this.cellConsumerWrapper.apply((Object)cellConsumer);
    }

    @Override
    public Iterator<String[]> iterator() {
        return new CsvStringArrayIterator(this);
    }

    public Iterator<Row> rowIterator() throws IOException {
        return new CsvRowArrayIterator(this);
    }

    private static Row.Headers headers(CsvReader reader) throws IOException {
        CellConsumerCapture cellConsumer = new CellConsumerCapture();
        reader.parseRow(cellConsumer);
        if (!cellConsumer.hasData()) {
            throw new EOFException("No headers");
        }
        return Row.headers(cellConsumer.values());
    }

    private static class CsvRowArrayIterator
    implements Iterator<Row> {
        private final CsvReader reader;
        private final CellConsumerFixLengthToCheckConsumer cellConsumer;
        private Row.Headers headers;
        private Row value;
        private boolean isFetched;

        public CsvRowArrayIterator(CsvReader csvReader) throws IOException {
            this.reader = csvReader;
            this.headers = CsvReader.headers(csvReader);
            this.cellConsumer = new CellConsumerFixLengthToCheckConsumer(this.headers.size(), new Consumer<String[]>(){

                public void accept(String[] strings) {
                    CsvRowArrayIterator.this.value = new Row(CsvRowArrayIterator.this.headers, strings);
                }
            });
        }

        @Override
        public boolean hasNext() {
            this.fetch();
            return this.value != null;
        }

        private void fetch() {
            if (!this.isFetched) {
                try {
                    this.value = null;
                    this.reader.parseRow(this.cellConsumer);
                }
                catch (IOException e) {
                    ErrorHelper.rethrow((Throwable)e);
                }
                this.isFetched = true;
            }
        }

        @Override
        public Row next() {
            this.fetch();
            if (this.value == null) {
                throw new NoSuchElementException();
            }
            this.isFetched = false;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CsvStringArrayIterator
    implements Iterator<String[]> {
        private final CsvReader reader;
        private final CellConsumer cellConsumer;
        private boolean isFetched;
        private String[] value;

        public CsvStringArrayIterator(CsvReader csvReader) {
            this.cellConsumer = csvReader.toCellConsumer((CheckedConsumer<String[]>)((CheckedConsumer)new CheckedConsumer<String[]>(){

                public void accept(String[] strings) {
                    CsvStringArrayIterator.access$002(CsvStringArrayIterator.this, strings);
                }
            }));
            this.reader = csvReader;
        }

        @Override
        public boolean hasNext() {
            this.fetch();
            return this.value != null;
        }

        private void fetch() {
            if (!this.isFetched) {
                try {
                    this.value = null;
                    this.reader.parseRow(this.cellConsumer);
                }
                catch (IOException e) {
                    ErrorHelper.rethrow((Throwable)e);
                }
                this.isFetched = true;
            }
        }

        @Override
        public String[] next() {
            this.fetch();
            if (this.value == null) {
                throw new NoSuchElementException();
            }
            this.isFetched = false;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ String[] access$002(CsvStringArrayIterator x0, String[] x1) {
            x0.value = x1;
            return x1;
        }
    }
}

