/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvMapper;
import org.simpleflatmapper.csv.CsvParser;
import org.simpleflatmapper.csv.CsvReader;
import org.simpleflatmapper.csv.impl.CsvMapperIterator;
import org.simpleflatmapper.csv.impl.DelegateCellSetter;
import org.simpleflatmapper.csv.impl.DelegateMarkerDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.DelegateMarkerSetter;
import org.simpleflatmapper.csv.mapper.BreakDetector;
import org.simpleflatmapper.csv.mapper.CellSetter;
import org.simpleflatmapper.csv.mapper.CsvMapperCellConsumer;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandlerFactory;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.csv.mapper.DelayedCellSetterFactory;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.util.CheckedConsumer;

public final class CsvMapperImpl<T>
implements CsvMapper<T> {
    private static final DelayedCellSetter[] EMPTY_DELAYED_CELL_SETTERS = new DelayedCellSetter[0];
    private final DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories;
    private final CellSetter<T>[] setters;
    private final CsvColumnKey[] joinKeys;
    private final ConsumerErrorHandler consumerErrorHandlers;
    private final CsvMapperCellHandlerFactory<T> csvMapperCellHandlerFactory;
    private final boolean hasSetterSubProperties;
    private final boolean hasSubProperties;
    private final int maxMandatoryCellIndex;

    public CsvMapperImpl(CsvMapperCellHandlerFactory<T> csvMapperCellHandlerFactory, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, CellSetter<T>[] setters, CsvColumnKey[] joinKeys, ConsumerErrorHandler consumerErrorHandlers, int maxMandatoryCellIndex) {
        this.csvMapperCellHandlerFactory = csvMapperCellHandlerFactory;
        this.delayedCellSetterFactories = delayedCellSetterFactories;
        this.setters = setters;
        this.joinKeys = joinKeys;
        this.consumerErrorHandlers = consumerErrorHandlers;
        this.hasSetterSubProperties = this.hasSetterSubProperties(setters);
        this.hasSubProperties = this.hasSetterSubProperties || this.hasDelayedMarker(delayedCellSetterFactories);
        this.maxMandatoryCellIndex = maxMandatoryCellIndex;
    }

    private boolean hasDelayedMarker(DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories) {
        for (DelayedCellSetterFactory<T, ?> setter : delayedCellSetterFactories) {
            if (!(setter instanceof DelegateMarkerDelayedCellSetterFactory)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSetterSubProperties(CellSetter<T>[] setters) {
        for (CellSetter<T> setter : setters) {
            if (!(setter instanceof DelegateMarkerSetter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handler) throws IOException, MappingException {
        return this.forEach(CsvParser.reader(reader), handler);
    }

    @Override
    public <H extends CheckedConsumer<? super T>> H forEach(CsvReader reader, H handle) throws IOException, MappingException {
        reader.parseAll(this.newCellConsumer(handle));
        return handle;
    }

    @Override
    public final <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handler, int skip) throws IOException, MappingException {
        return this.forEach(CsvParser.skip(skip).reader(reader), handler);
    }

    @Override
    public final <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handler, int skip, int limit) throws IOException, MappingException {
        return this.forEach(CsvParser.skip(skip).reader(reader), handler, limit);
    }

    @Override
    public final <H extends CheckedConsumer<? super T>> H forEach(CsvReader reader, H handle, int limit) throws IOException, MappingException {
        reader.parseRows(this.newCellConsumer(handle), limit);
        return handle;
    }

    @Override
    public Iterator<T> iterator(Reader reader) throws IOException {
        return this.iterator(CsvParser.reader(reader));
    }

    @Override
    public Iterator<T> iterator(CsvReader csvReader) {
        return new CsvMapperIterator(csvReader, this);
    }

    @Override
    public Iterator<T> iterator(Reader reader, int skip) throws IOException {
        return this.iterator(CsvParser.skip(skip).reader(reader));
    }

    protected CsvMapperCellConsumer newCellConsumer(CheckedConsumer<? super T> handler) {
        return this.newCellConsumer(handler, null, false);
    }

    protected CsvMapperCellConsumer<T> newCellConsumer(CheckedConsumer<? super T> handler, BreakDetector parentBreakDetector, boolean appendCollection) {
        CsvMapperCellConsumer[] cellHandlers = null;
        if (this.hasSubProperties) {
            cellHandlers = new CsvMapperCellConsumer[this.delayedCellSetterFactories.length + this.setters.length];
        }
        BreakDetector breakDetector = null;
        if (this.joinKeys != null && this.joinKeys.length > 0 || !appendCollection) {
            breakDetector = this.newBreakDetector(parentBreakDetector, this.delayedCellSetterFactories.length - 1);
        }
        DelayedCellSetter<T, ?>[] outDelayedCellSetters = this.getDelayedCellSetters(cellHandlers, breakDetector);
        CellSetter<T>[] outSetters = this.getCellSetters(cellHandlers, breakDetector);
        CsvMapperCellHandler<T> mapperSetters = this.csvMapperCellHandlerFactory.newInstance(outDelayedCellSetters, outSetters);
        return new CsvMapperCellConsumer<T>(mapperSetters, this.consumerErrorHandlers, handler, breakDetector, this.toList(cellHandlers), this.maxMandatoryCellIndex);
    }

    private DelayedCellSetter<T, ?>[] getDelayedCellSetters(CsvMapperCellConsumer<?>[] cellHandlers, BreakDetector breakDetector) {
        if (this.delayedCellSetterFactories.length == 0) {
            return EMPTY_DELAYED_CELL_SETTERS;
        }
        return this.buildDelayedCellSetters(cellHandlers, breakDetector);
    }

    private DelayedCellSetter<T, ?>[] buildDelayedCellSetters(CsvMapperCellConsumer<?>[] cellHandlers, BreakDetector breakDetector) {
        DelayedCellSetter[] outDelayedCellSetters = new DelayedCellSetter[this.delayedCellSetterFactories.length];
        for (int i = this.delayedCellSetterFactories.length - 1; i >= 0; --i) {
            DelayedCellSetterFactory<T, ?> delayedCellSetterFactory = this.delayedCellSetterFactories[i];
            if (delayedCellSetterFactory == null) continue;
            outDelayedCellSetters[i] = delayedCellSetterFactory.newCellSetter(breakDetector, cellHandlers);
        }
        return outDelayedCellSetters;
    }

    private Collection<CsvMapperCellConsumer<?>> toList(CsvMapperCellConsumer<?>[] cellHandlers) {
        if (cellHandlers == null) {
            return Collections.emptyList();
        }
        ArrayList consumers = new ArrayList();
        for (CsvMapperCellConsumer<?> consumer : cellHandlers) {
            if (consumer == null) continue;
            consumers.add(consumer);
        }
        return consumers;
    }

    private CellSetter<T>[] getCellSetters(CsvMapperCellConsumer<?>[] cellHandlers, BreakDetector breakDetector) {
        if (this.hasSetterSubProperties) {
            return this.rebuildCellSetters(cellHandlers, breakDetector);
        }
        return this.setters;
    }

    private CellSetter<T>[] rebuildCellSetters(CsvMapperCellConsumer<?>[] cellHandlers, BreakDetector breakDetector) {
        CellSetter[] outSetters = new CellSetter[this.setters.length];
        for (int i = this.setters.length - 1; i >= 0; --i) {
            DelegateCellSetter delegateCellSetter;
            outSetters[i] = this.setters[i] instanceof DelegateMarkerSetter ? (delegateCellSetter = this.getDelegateCellSetter((DelegateMarkerSetter)this.setters[i], cellHandlers, breakDetector, i)) : this.setters[i];
        }
        return outSetters;
    }

    private <P> DelegateCellSetter<T, P> getDelegateCellSetter(DelegateMarkerSetter marker, CsvMapperCellConsumer<?>[] cellHandlers, BreakDetector breakDetector, int i) {
        int cellIndex;
        int parent = marker.getParent();
        if (parent == (cellIndex = i + this.delayedCellSetterFactories.length)) {
            DelegateCellSetter tpDelegateCellSetter = new DelegateCellSetter(marker, cellIndex, breakDetector);
            cellHandlers[cellIndex] = tpDelegateCellSetter.getCellConsumer();
            return tpDelegateCellSetter;
        }
        CsvMapperCellConsumer<?> cellHandler = cellHandlers[parent];
        if (cellHandler == null) {
            throw new NullPointerException("No cell handler on parent " + parent);
        }
        return new DelegateCellSetter(marker, cellHandler, cellIndex);
    }

    private BreakDetector newBreakDetector(BreakDetector parentBreakDetector, int delayedSetterEnd) {
        if (parentBreakDetector != null || this.joinKeys.length > 0) {
            return new BreakDetector(this.joinKeys, parentBreakDetector, delayedSetterEnd);
        }
        return null;
    }

    public CsvMapperCellHandlerFactory<T> csvMapperCellHandlerFactory() {
        return this.csvMapperCellHandlerFactory;
    }

    public String toString() {
        return "CsvMapperImpl{targetSettersFactory=" + this.csvMapperCellHandlerFactory + ", delayedCellSetters=" + Arrays.toString(this.delayedCellSetterFactories) + ", setters=" + Arrays.toString(this.setters) + '}';
    }
}

