/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.asm;

import java.lang.reflect.Type;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.ParsingContextFactory;
import org.simpleflatmapper.csv.mapper.CellSetter;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandlerFactory;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.csv.mapper.DelayedCellSetterFactory;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.FieldVisitor;
import org.simpleflatmapper.ow2asm.Label;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.ow2asm.Opcodes;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.reflect.asm.ShardingHelper;

public class CsvMapperCellHandlerBuilder {
    public static final String DELAYED_CELL_SETTER_TYPE = AsmUtils.toAsmType(DelayedCellSetter.class);
    public static final String CELL_SETTER_TYPE = AsmUtils.toAsmType(CellSetter.class);
    public static final String CSV_CELL_MAPPER_TYPE = AsmUtils.toAsmType(CsvMapperCellHandler.class);
    public static final String CELL_HANDLER_FACTORY_TYPE = AsmUtils.toAsmType(CsvMapperCellHandlerFactory.class);

    public static <T> byte[] createTargetSetterClass(String className, DelayedCellSetterFactory<T, ?>[] delayedCellSetters, CellSetter<T>[] setters, Type type, boolean ignoreException, int maxMethodSize) throws Exception {
        FieldVisitor fv;
        int i;
        ClassWriter cw = new ClassWriter(1);
        String targetType = AsmUtils.toAsmType((Type)type);
        String classType = AsmUtils.toAsmType((String)className);
        cw.visit(50, 49, classType, "L" + CSV_CELL_MAPPER_TYPE + "<L" + targetType + ";>;", CSV_CELL_MAPPER_TYPE, null);
        for (i = 0; i < delayedCellSetters.length; ++i) {
            if (delayedCellSetters[i] == null) continue;
            fv = cw.visitField(20, "delayedCellSetter" + i, AsmUtils.toTargetTypeDeclaration((String)DELAYED_CELL_SETTER_TYPE), "L" + DELAYED_CELL_SETTER_TYPE + "<L" + targetType + ";*>;", null);
            fv.visitEnd();
        }
        for (i = 0; i < setters.length; ++i) {
            if (setters[i] == null) continue;
            fv = cw.visitField(20, "setter" + i, AsmUtils.toTargetTypeDeclaration((String)CELL_SETTER_TYPE), "L" + CELL_SETTER_TYPE + "<L" + targetType + ";>;", null);
            fv.visitEnd();
        }
        CsvMapperCellHandlerBuilder.appendInit(delayedCellSetters, setters, cw, targetType, classType, maxMethodSize);
        CsvMapperCellHandlerBuilder.appendDelayedCellValue(delayedCellSetters, ignoreException, cw, classType);
        CsvMapperCellHandlerBuilder.append_delayedCellValue(delayedCellSetters, cw, classType, maxMethodSize);
        CsvMapperCellHandlerBuilder.appendCellValue(setters, ignoreException, cw, classType);
        CsvMapperCellHandlerBuilder.append_cellValue(delayedCellSetters, setters, cw, classType, maxMethodSize);
        CsvMapperCellHandlerBuilder.appendApplyDelayedSetter(delayedCellSetters, ignoreException, cw, classType, maxMethodSize);
        CsvMapperCellHandlerBuilder.appendApplyDelayedCellSetterN(delayedCellSetters, cw, classType);
        CsvMapperCellHandlerBuilder.appendGetDelayedCellSetter(delayedCellSetters, cw, targetType, classType, maxMethodSize);
        CsvMapperCellHandlerBuilder.appendPeekDelayedCellSetterValue(delayedCellSetters, cw, classType, maxMethodSize);
        cw.visitEnd();
        return AsmUtils.writeClassToFile((String)className, (byte[])cw.toByteArray());
    }

    private static <T> void append_cellValue(final DelayedCellSetterFactory<T, ?>[] delayedCellSetters, final CellSetter<T>[] setters, ClassWriter cw, final String classType, int maxMethodSize) {
        ShardingHelper.shard((int)setters.length, (int)maxMethodSize, (ShardingHelper.ShardCallBack)new AbstractMethodDispatchShardCallBack<T>(cw, classType, maxMethodSize){

            @Override
            protected void appendLeafSwitch(MethodVisitor mv, int start, int end) {
                Label defaultLabel = new Label();
                Label[] labels = CsvMapperCellHandlerBuilder.newLabels(end - start);
                mv.visitTableSwitchInsn(delayedCellSetters.length + start, delayedCellSetters.length + end - 1, defaultLabel, labels);
                for (int i = start; i < end; ++i) {
                    mv.visitLabel(labels[i - start]);
                    mv.visitFrame(3, 0, null, 0, null);
                    if (setters[i] != null) {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, classType, "setter" + i, "L" + CELL_SETTER_TYPE + ";");
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, classType, "currentInstance", "Ljava/lang/Object;");
                        mv.visitVarInsn(25, 1);
                        mv.visitVarInsn(21, 2);
                        mv.visitVarInsn(21, 3);
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, classType, "parsingContext", AsmUtils.toTargetTypeDeclaration(ParsingContext.class));
                        mv.visitMethodInsn(185, CELL_SETTER_TYPE, "set", "(Ljava/lang/Object;[CIIL" + AsmUtils.toAsmType(ParsingContext.class) + ";)V", true);
                    }
                    if (i >= end - 1) continue;
                    mv.visitJumpInsn(167, defaultLabel);
                }
                mv.visitLabel(defaultLabel);
                mv.visitFrame(3, 0, null, 0, null);
            }

            @Override
            protected int maxArgIndex() {
                return 4;
            }

            @Override
            protected void loadArguments(MethodVisitor mv) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(21, 2);
                mv.visitVarInsn(21, 3);
                mv.visitVarInsn(21, 4);
            }

            @Override
            protected int argIndex() {
                return 4;
            }

            @Override
            protected String name() {
                return "_cellValue";
            }

            @Override
            protected String signature() {
                return "([CIII)V";
            }

            @Override
            protected int leafStart() {
                return delayedCellSetters.length;
            }
        });
    }

    private static <T> void appendPeekDelayedCellSetterValue(final DelayedCellSetterFactory<T, ?>[] delayedCellSetters, ClassWriter cw, final String classType, int maxMethodSize) {
        ShardingHelper.shard((int)delayedCellSetters.length, (int)maxMethodSize, (ShardingHelper.ShardCallBack)new AbstractMethodDispatchShardCallBack<T>(cw, classType, maxMethodSize){

            @Override
            protected void appendLeafSwitch(MethodVisitor mv, int start, int end) {
                Label defaultLabel = new Label();
                Label[] labels = CsvMapperCellHandlerBuilder.newLabels(end - start);
                mv.visitTableSwitchInsn(start, end - 1, defaultLabel, labels);
                for (int i = start; i < end; ++i) {
                    mv.visitLabel(labels[i - start]);
                    mv.visitFrame(3, 0, null, 0, null);
                    if (delayedCellSetters[i] != null) {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, classType, "delayedCellSetter" + i, "L" + DELAYED_CELL_SETTER_TYPE + ";");
                        mv.visitMethodInsn(185, DELAYED_CELL_SETTER_TYPE, "peekValue", "()Ljava/lang/Object;", true);
                        mv.visitInsn(176);
                        continue;
                    }
                    if (i >= delayedCellSetters.length - 1) continue;
                    mv.visitInsn(1);
                    mv.visitInsn(176);
                }
                mv.visitLabel(defaultLabel);
                mv.visitFrame(3, 0, null, 0, null);
            }

            @Override
            protected int maxArgIndex() {
                return 1;
            }

            @Override
            protected void loadArguments(MethodVisitor mv) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(21, 1);
            }

            @Override
            protected int argIndex() {
                return 1;
            }

            @Override
            protected String name() {
                return "_peekDelayedCellSetterValue";
            }

            @Override
            protected String signature() {
                return "(I)Ljava/lang/Object;";
            }
        });
        MethodVisitor mv = cw.visitMethod(1, "peekDelayedCellSetterValue", "(L" + AsmUtils.toAsmType(CsvColumnKey.class) + ";)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, AsmUtils.toAsmType(CsvColumnKey.class), "getIndex", "()I", false);
        mv.visitVarInsn(54, 2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, classType, "_peekDelayedCellSetterValue", "(I)Ljava/lang/Object;", false);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
    }

    private static <T> void append_delayedCellValue(final DelayedCellSetterFactory<T, ?>[] delayedCellSetters, ClassWriter cw, final String classType, int maxMethodSize) {
        ShardingHelper.shard((int)delayedCellSetters.length, (int)maxMethodSize, (ShardingHelper.ShardCallBack)new AbstractMethodDispatchShardCallBack<T>(cw, classType, maxMethodSize){

            @Override
            protected void appendLeafSwitch(MethodVisitor mv, int start, int end) {
                Label defaultLabel = new Label();
                Label[] labels = CsvMapperCellHandlerBuilder.newLabels(end - start);
                mv.visitTableSwitchInsn(start, end - 1, defaultLabel, labels);
                for (int i = start; i < end; ++i) {
                    mv.visitLabel(labels[i - start]);
                    mv.visitFrame(3, 0, null, 0, null);
                    if (delayedCellSetters[i] != null) {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, classType, "delayedCellSetter" + i, "L" + DELAYED_CELL_SETTER_TYPE + ";");
                        mv.visitVarInsn(25, 1);
                        mv.visitVarInsn(21, 2);
                        mv.visitVarInsn(21, 3);
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, classType, "parsingContext", AsmUtils.toTargetTypeDeclaration(ParsingContext.class));
                        mv.visitMethodInsn(185, DELAYED_CELL_SETTER_TYPE, "set", "([CIIL" + AsmUtils.toAsmType(ParsingContext.class) + ";)V", true);
                    }
                    if (i >= end - 1) continue;
                    mv.visitJumpInsn(167, defaultLabel);
                }
                mv.visitLabel(defaultLabel);
                mv.visitFrame(3, 0, null, 0, null);
            }

            @Override
            protected void loadArguments(MethodVisitor mv) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(21, 2);
                mv.visitVarInsn(21, 3);
                mv.visitVarInsn(21, 4);
            }

            @Override
            protected int maxArgIndex() {
                return 4;
            }

            @Override
            protected int argIndex() {
                return 4;
            }

            @Override
            protected String name() {
                return "_delayedCellValue";
            }

            @Override
            protected String signature() {
                return "([CIII)V";
            }
        });
    }

    private static <T> void appendApplyDelayedSetter(final DelayedCellSetterFactory<T, ?>[] delayedCellSetters, final boolean ignoreException, final ClassWriter cw, final String classType, final int maxMethodSize) {
        ShardingHelper.shard((int)delayedCellSetters.length, (int)maxMethodSize, (ShardingHelper.ShardCallBack)new ShardingHelper.ShardCallBack(){

            public void leafDispatch(String suffix, int start, int end) {
                MethodVisitor mv = cw.visitMethod(1, "applyDelayedSetters" + suffix, "()V", null, null);
                mv.visitCode();
                if (end - start > 0) {
                    if (!ignoreException) {
                        int i;
                        Label[] labels = CsvMapperCellHandlerBuilder.newLabels(3 * CsvMapperCellHandlerBuilder.getNbNonNullSettersWithSetters(delayedCellSetters, start, end) + 1);
                        int j = 0;
                        for (i = start; i < end; ++i) {
                            if (delayedCellSetters[i] == null || !delayedCellSetters[i].hasSetter()) continue;
                            mv.visitTryCatchBlock(labels[j], labels[j + 1], labels[j + 2], "java/lang/Exception");
                            j += 3;
                        }
                        j = 0;
                        for (i = start; i < end; ++i) {
                            if (delayedCellSetters[i] == null || !delayedCellSetters[i].hasSetter()) continue;
                            mv.visitLabel(labels[j]);
                            if (j > 0) {
                                mv.visitFrame(3, 0, null, 0, null);
                            }
                            mv.visitVarInsn(25, 0);
                            mv.visitMethodInsn(183, classType, "applyDelayedCellSetter" + i, "()V", false);
                            mv.visitLabel(labels[j + 1]);
                            mv.visitJumpInsn(167, labels[j + 3]);
                            mv.visitLabel(labels[j + 2]);
                            mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Exception"});
                            mv.visitVarInsn(58, 1);
                            mv.visitVarInsn(25, 0);
                            AsmUtils.addIndex((MethodVisitor)mv, (int)i);
                            mv.visitVarInsn(25, 1);
                            mv.visitMethodInsn(182, classType, "fieldError", "(ILjava/lang/Exception;)V", false);
                            j += 3;
                        }
                        mv.visitLabel(labels[labels.length - 1]);
                        mv.visitFrame(3, 0, null, 0, null);
                    } else {
                        for (int i = start; i < end; ++i) {
                            if (delayedCellSetters[i] == null || !delayedCellSetters[i].hasSetter()) continue;
                            mv.visitVarInsn(25, 0);
                            mv.visitMethodInsn(183, classType, "applyDelayedCellSetter" + i, "()V", false);
                        }
                    }
                }
                mv.visitInsn(177);
                mv.visitMaxs(3, 2);
                mv.visitEnd();
            }

            public void nodeDispatch(String suffix, int divide, int start, int end) {
                MethodVisitor mv = cw.visitMethod(1, "applyDelayedSetters" + suffix, "()V", null, new String[]{"java/lang/Exception"});
                mv.visitCode();
                int powerOfTwo = Integer.numberOfTrailingZeros(divide);
                int sStart = start >> powerOfTwo;
                int sEnd = end >> powerOfTwo;
                int left = end - (sEnd << powerOfTwo);
                if (left > 0) {
                    ++sEnd;
                }
                for (int i = sStart; i < sEnd; ++i) {
                    int estart = i * divide;
                    int eend = Math.min(end, (i + 1) * divide);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(183, classType, "applyDelayedSetters" + divide / maxMethodSize + "n" + estart + "t" + eend, "()V", false);
                }
                mv.visitInsn(177);
                mv.visitMaxs(6, 5);
                mv.visitEnd();
            }
        });
    }

    private static Label[] newLabels(int ll) {
        Label[] labels = new Label[ll];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
        }
        return labels;
    }

    private static <T> void appendApplyDelayedCellSetterN(DelayedCellSetterFactory<T, ?>[] delayedCellSetters, ClassWriter cw, String classType) {
        for (int i = 0; i < delayedCellSetters.length; ++i) {
            if (delayedCellSetters[i] == null) continue;
            MethodVisitor mv = cw.visitMethod(2, "applyDelayedCellSetter" + i, "()V", null, new String[]{"java/lang/Exception"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, classType, "delayedCellSetter" + i, "L" + DELAYED_CELL_SETTER_TYPE + ";");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, classType, "currentInstance", "Ljava/lang/Object;");
            mv.visitMethodInsn(185, DELAYED_CELL_SETTER_TYPE, "set", "(Ljava/lang/Object;)V", true);
            mv.visitInsn(177);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
    }

    private static <T> void appendCellValue(CellSetter<T>[] setters, boolean ignoreException, ClassWriter cw, String classType) {
        MethodVisitor mv = cw.visitMethod(1, "cellValue", "([CIII)V", null, null);
        mv.visitCode();
        if (setters.length != 0) {
            if (ignoreException) {
                CsvMapperCellHandlerBuilder.callCellValue(mv, classType);
            } else {
                Label l0 = new Label();
                Label l1 = new Label();
                Label l2 = new Label();
                mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Exception");
                mv.visitLabel(l0);
                CsvMapperCellHandlerBuilder.callCellValue(mv, classType);
                mv.visitLabel(l1);
                Label l3 = new Label();
                mv.visitJumpInsn(167, l3);
                mv.visitLabel(l2);
                mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Exception"});
                mv.visitVarInsn(58, 5);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(21, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, classType, "fieldError", "(ILjava/lang/Exception;)V", false);
                mv.visitLabel(l3);
                mv.visitFrame(3, 0, null, 0, null);
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(5, 6);
        mv.visitEnd();
    }

    private static <T> void appendDelayedCellValue(DelayedCellSetterFactory<T, ?>[] delayedCellSetters, boolean ignoreException, ClassWriter cw, String classType) {
        MethodVisitor mv = cw.visitMethod(1, "delayedCellValue", "([CIII)V", null, null);
        mv.visitCode();
        if (delayedCellSetters.length != 0) {
            if (ignoreException) {
                CsvMapperCellHandlerBuilder.callDelayedCellValue(mv, classType);
            } else {
                Label l0 = new Label();
                Label l1 = new Label();
                Label l2 = new Label();
                mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Exception");
                mv.visitLabel(l0);
                CsvMapperCellHandlerBuilder.callDelayedCellValue(mv, classType);
                mv.visitLabel(l1);
                Label l3 = new Label();
                mv.visitJumpInsn(167, l3);
                mv.visitLabel(l2);
                mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Exception"});
                mv.visitVarInsn(58, 5);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(21, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, classType, "fieldError", "(ILjava/lang/Exception;)V", false);
                mv.visitLabel(l3);
                mv.visitFrame(3, 0, null, 0, null);
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(5, 6);
        mv.visitEnd();
    }

    private static <T> void appendInit(DelayedCellSetterFactory<T, ?>[] delayedCellSetters, CellSetter<T>[] setters, ClassWriter cw, String targetType, String classType, int maxSize) {
        int i;
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + AsmUtils.toTargetTypeDeclaration(Instantiator.class) + AsmUtils.toTargetTypeDeclaration(DelayedCellSetter[].class) + AsmUtils.toTargetTypeDeclaration(CellSetter[].class) + AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class) + AsmUtils.toTargetTypeDeclaration(ParsingContext.class) + AsmUtils.toTargetTypeDeclaration(FieldMapperErrorHandler.class) + ")V", "(L" + AsmUtils.toAsmType(Instantiator.class) + "<L" + AsmUtils.toAsmType(CsvMapperCellHandler.class) + "<L" + targetType + ";>;L" + targetType + ";>;" + "[L" + DELAYED_CELL_SETTER_TYPE + "<L" + targetType + ";*>;" + "[L" + CELL_SETTER_TYPE + "<L" + targetType + ";>;" + AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class) + AsmUtils.toTargetTypeDeclaration(ParsingContext.class) + "L" + AsmUtils.toAsmType(FieldMapperErrorHandler.class) + "<L" + AsmUtils.toAsmType(CsvColumnKey.class) + ";>;" + ")V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 4);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(190);
        mv.visitVarInsn(25, 3);
        mv.visitInsn(190);
        mv.visitVarInsn(25, 5);
        mv.visitVarInsn(25, 6);
        mv.visitMethodInsn(183, CSV_CELL_MAPPER_TYPE, "<init>", "(" + AsmUtils.toTargetTypeDeclaration(Instantiator.class) + AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class) + "I" + "I" + AsmUtils.toTargetTypeDeclaration(ParsingContext.class) + AsmUtils.toTargetTypeDeclaration(FieldMapperErrorHandler.class) + ")V", false);
        ShardingHelper.shard((int)delayedCellSetters.length, (int)maxSize, (ShardingHelper.ShardCallBack)new ShardingHelper.ShardCallBack(){

            public void leafDispatch(String suffix, int start, int end) {
            }

            public void nodeDispatch(String suffix, int divide, int start, int end) {
            }
        });
        for (i = 0; i < delayedCellSetters.length; ++i) {
            if (delayedCellSetters[i] == null) continue;
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            AsmUtils.addIndex((MethodVisitor)mv, (int)i);
            mv.visitInsn(50);
            mv.visitFieldInsn(181, classType, "delayedCellSetter" + i, AsmUtils.toTargetTypeDeclaration((String)DELAYED_CELL_SETTER_TYPE));
        }
        for (i = 0; i < setters.length; ++i) {
            if (setters[i] == null) continue;
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 3);
            AsmUtils.addIndex((MethodVisitor)mv, (int)i);
            mv.visitInsn(50);
            mv.visitFieldInsn(181, classType, "setter" + i, AsmUtils.toTargetTypeDeclaration((String)CELL_SETTER_TYPE));
        }
        mv.visitInsn(177);
        mv.visitMaxs(7, 7);
        mv.visitEnd();
    }

    private static <T> void appendGetDelayedCellSetter(DelayedCellSetterFactory<T, ?>[] delayedCellSetters, ClassWriter cw, String targetType, String classType, int maxMethodSize) {
        MethodVisitor mv = cw.visitMethod(1, "getDelayedCellSetter", "(I)L" + DELAYED_CELL_SETTER_TYPE + ";", "(I)L" + DELAYED_CELL_SETTER_TYPE + "<L" + targetType + ";*>;", null);
        mv.visitCode();
        if (delayedCellSetters.length != 0) {
            boolean switchStart = false;
            int switchEnd = delayedCellSetters.length;
            CsvMapperCellHandlerBuilder.appendGetDelayedCellSetterSwitch(delayedCellSetters, classType, mv, 0, switchEnd);
        }
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
    }

    private static <T> void appendGetDelayedCellSetterSwitch(DelayedCellSetterFactory<T, ?>[] delayedCellSetters, String classType, MethodVisitor mv, int switchStart, int switchEnd) {
        mv.visitVarInsn(21, 1);
        Label defaultLabel = new Label();
        Label[] labels = CsvMapperCellHandlerBuilder.newLabels(switchEnd - switchStart);
        mv.visitTableSwitchInsn(switchStart, switchEnd - 1, defaultLabel, labels);
        for (int i = switchStart; i < switchEnd; ++i) {
            mv.visitLabel(labels[i - switchStart]);
            mv.visitFrame(3, 0, null, 0, null);
            if (delayedCellSetters != null) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, classType, "delayedCellSetter" + i, "L" + DELAYED_CELL_SETTER_TYPE + ";");
            } else {
                mv.visitInsn(1);
            }
            mv.visitInsn(176);
        }
        mv.visitLabel(defaultLabel);
        mv.visitFrame(3, 0, null, 0, null);
    }

    private static void callCellValue(MethodVisitor mv, String classType) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 3);
        mv.visitVarInsn(21, 4);
        mv.visitMethodInsn(183, classType, "_cellValue", "([CIII)V", false);
    }

    private static void callDelayedCellValue(MethodVisitor mv, String classType) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 3);
        mv.visitVarInsn(21, 4);
        mv.visitMethodInsn(183, classType, "_delayedCellValue", "([CIII)V", false);
    }

    private static <T> int getNbNonNullSettersWithSetters(DelayedCellSetterFactory<T, ?>[] delayedCellSetters, int start, int end) {
        int n = 0;
        for (int i = start; i < end; ++i) {
            if (delayedCellSetters[i] == null || !delayedCellSetters[i].hasSetter()) continue;
            ++n;
        }
        return n;
    }

    public static byte[] createTargetSetterFactory(String factoryName, String className, Type target) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        String factoryType = AsmUtils.toAsmType((String)factoryName);
        String classType = AsmUtils.toAsmType((String)className);
        String targetType = AsmUtils.toAsmType((Type)target);
        cw.visit(50, 49, factoryType, "L" + CELL_HANDLER_FACTORY_TYPE + "<L" + targetType + ";>;", CELL_HANDLER_FACTORY_TYPE, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + AsmUtils.toTargetTypeDeclaration(Instantiator.class) + AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class) + AsmUtils.toTargetTypeDeclaration(ParsingContextFactory.class) + AsmUtils.toTargetTypeDeclaration(FieldMapperErrorHandler.class) + ")V", "(L" + AsmUtils.toAsmType(Instantiator.class) + "<L" + AsmUtils.toAsmType(CsvMapperCellHandler.class) + "<L" + targetType + ";>;L" + targetType + ";>;" + AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class) + AsmUtils.toTargetTypeDeclaration(ParsingContextFactory.class) + "L" + AsmUtils.toAsmType(FieldMapperErrorHandler.class) + "<L" + AsmUtils.toAsmType(CsvColumnKey.class) + ";>;" + ")V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(183, CELL_HANDLER_FACTORY_TYPE, "<init>", "(" + AsmUtils.toTargetTypeDeclaration(Instantiator.class) + AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class) + AsmUtils.toTargetTypeDeclaration(ParsingContextFactory.class) + AsmUtils.toTargetTypeDeclaration(FieldMapperErrorHandler.class) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
        mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(DelayedCellSetter[].class) + AsmUtils.toTargetTypeDeclaration(CellSetter[].class) + ")" + AsmUtils.toTargetTypeDeclaration(CsvMapperCellHandler.class), "([L" + DELAYED_CELL_SETTER_TYPE + "<L" + targetType + ";*>;" + "[L" + CELL_SETTER_TYPE + "<L" + targetType + ";>;" + ")" + "L" + AsmUtils.toAsmType(CsvMapperCellHandler.class) + "<L" + targetType + ";>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, classType);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, factoryType, "instantiator", AsmUtils.toTargetTypeDeclaration(Instantiator.class));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, factoryType, "keys", AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, factoryType, "parsingContextFactory", AsmUtils.toTargetTypeDeclaration(ParsingContextFactory.class));
        mv.visitMethodInsn(182, AsmUtils.toAsmType(ParsingContextFactory.class), "newContext", "()" + AsmUtils.toTargetTypeDeclaration(ParsingContext.class), false);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, factoryType, "fieldErrorHandler", AsmUtils.toTargetTypeDeclaration(FieldMapperErrorHandler.class));
        mv.visitMethodInsn(183, classType, "<init>", "(" + AsmUtils.toTargetTypeDeclaration(Instantiator.class) + AsmUtils.toTargetTypeDeclaration(DelayedCellSetter[].class) + AsmUtils.toTargetTypeDeclaration(CellSetter[].class) + AsmUtils.toTargetTypeDeclaration(CsvColumnKey[].class) + AsmUtils.toTargetTypeDeclaration(ParsingContext.class) + AsmUtils.toTargetTypeDeclaration(FieldMapperErrorHandler.class) + ")V", false);
        mv.visitInsn(176);
        mv.visitMaxs(8, 3);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static abstract class AbstractMethodDispatchShardCallBack<T>
    implements ShardingHelper.ShardCallBack {
        private final ClassWriter cw;
        private final String classType;
        private final int maxMethodSize;

        public AbstractMethodDispatchShardCallBack(ClassWriter cw, String classType, int maxMethodSize) {
            this.cw = cw;
            this.classType = classType;
            this.maxMethodSize = maxMethodSize;
        }

        public void leafDispatch(String suffix, int start, int end) {
            MethodVisitor mv = this.cw.visitMethod(1, this.name() + suffix, this.signature(), null, null);
            mv.visitCode();
            if (end - start > 0) {
                mv.visitVarInsn(21, this.argIndex());
                this.appendLeafSwitch(mv, start, end);
            }
            if (this.isVoid()) {
                mv.visitInsn(177);
            } else {
                mv.visitInsn(1);
                mv.visitInsn(176);
            }
            mv.visitMaxs(1, 2);
            mv.visitEnd();
        }

        protected abstract void appendLeafSwitch(MethodVisitor var1, int var2, int var3);

        public void nodeDispatch(String suffix, int divide, int start, int end) {
            MethodVisitor mv = this.cw.visitMethod(2, this.name() + suffix, this.signature(), null, null);
            mv.visitCode();
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            int powerOfTwo = Integer.numberOfTrailingZeros(divide);
            int sStart = start >> powerOfTwo;
            int sEnd = end >> powerOfTwo;
            int left = end - (sEnd << powerOfTwo);
            if (left > 0) {
                ++sEnd;
            }
            Label[] labels = CsvMapperCellHandlerBuilder.newLabels(sEnd - sStart);
            Label defaultLabel = new Label();
            mv.visitVarInsn(21, this.argIndex());
            int sub = this.leafStart();
            if (sub != 0) {
                AsmUtils.addIndex((MethodVisitor)mv, (int)sub);
                mv.visitInsn(100);
            }
            AsmUtils.addIndex((MethodVisitor)mv, (int)powerOfTwo);
            mv.visitInsn(122);
            mv.visitVarInsn(54, this.maxArgIndex() + 1);
            mv.visitVarInsn(21, this.maxArgIndex() + 1);
            mv.visitTableSwitchInsn(sStart, sEnd - 1, defaultLabel, labels);
            for (int i = sStart; i < sEnd; ++i) {
                int estart = i << powerOfTwo;
                int eend = Math.min(end, i + 1 << powerOfTwo);
                mv.visitLabel(labels[i - sStart]);
                if (i == start) {
                    mv.visitFrame(1, 1, new Object[]{Opcodes.INTEGER}, 0, null);
                } else {
                    mv.visitFrame(3, 0, null, 0, null);
                }
                this.loadArguments(mv);
                mv.visitMethodInsn(183, this.classType, this.name() + divide / this.maxMethodSize + "n" + estart + "t" + eend, this.signature(), false);
                if (this.isVoid()) {
                    if (i >= sEnd - 1) continue;
                    mv.visitJumpInsn(167, defaultLabel);
                    continue;
                }
                mv.visitInsn(176);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
            if (this.isVoid()) {
                mv.visitInsn(177);
            } else {
                mv.visitInsn(1);
                mv.visitInsn(176);
            }
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            this.appendDebugInfo(mv, startLabel, endLabel);
            mv.visitMaxs(6, 5);
            mv.visitEnd();
        }

        protected int leafStart() {
            return 0;
        }

        protected abstract int maxArgIndex();

        protected void appendDebugInfo(MethodVisitor mv, Label startLabel, Label endLabel) {
        }

        protected abstract void loadArguments(MethodVisitor var1);

        protected abstract int argIndex();

        private boolean isVoid() {
            return this.signature().endsWith("V");
        }

        protected abstract String name();

        protected abstract String signature();
    }
}

