/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.simpleflatmapper.csv.parser.BufferOverflowException;
import org.simpleflatmapper.csv.parser.CharBuffer;

public final class ReaderCharBuffer
extends CharBuffer {
    private final int maxBufferSize;
    private final Reader reader;
    private int resizeThreshold;

    public ReaderCharBuffer(int bufferSize, int maxBufferLength, Reader reader) {
        super(new char[bufferSize], 0);
        this.maxBufferSize = maxBufferLength;
        this.reader = reader;
        this.resizeThreshold = (this.buffer.length >> 2) * 3;
    }

    @Override
    public final boolean next() throws IOException {
        int effectiveMark = Math.min(this.bufferSize, this.mark);
        int newSize = this.bufferSize - effectiveMark;
        char[] lbuffer = this.buffer;
        System.arraycopy(lbuffer, effectiveMark, lbuffer, 0, newSize);
        this.bufferSize = newSize;
        this.mark = 0;
        if (newSize > this.resizeThreshold) {
            int newBufferSize = Math.min(this.maxBufferSize, lbuffer.length << 1);
            if (newBufferSize <= newSize) {
                throw new BufferOverflowException("The content in the csv cell exceed the maxSizeBuffer " + this.maxBufferSize + ", see CsvParser.DSL.maxSizeBuffer(int) to change the default value");
            }
            this.buffer = lbuffer = Arrays.copyOf(lbuffer, newBufferSize);
            this.resizeThreshold = (newBufferSize >> 2) * 3;
        }
        int l = this.reader.read(lbuffer, newSize, lbuffer.length - newSize);
        this.bufferSize += Math.max(0, l);
        return l > 0;
    }
}

