/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import org.simpleflatmapper.datastax.DataHelper;
import org.simpleflatmapper.datastax.DataTypeHelper;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.primitive.ShortGetter;

public class DatastaxGenericShortGetter
implements ShortGetter<GettableByIndexData>,
Getter<GettableByIndexData, Short> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericShortGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        if (DataTypeHelper.isNumber(name)) {
            return name;
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public Short get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        return this.getShort(target);
    }

    public short getShort(GettableByIndexData target) throws Exception {
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return (short)target.getLong(this.index);
            }
            case VARINT: {
                return target.getVarint(this.index).shortValue();
            }
            case INT: {
                return (short)target.getInt(this.index);
            }
            case DECIMAL: {
                return target.getDecimal(this.index).shortValue();
            }
            case FLOAT: {
                return (short)target.getFloat(this.index);
            }
            case DOUBLE: {
                return (short)target.getDouble(this.index);
            }
        }
        if (DataTypeHelper.isSmallInt(this.dataTypeName)) {
            return DataHelper.getShort(this.index, target);
        }
        if (DataTypeHelper.isTinyInt(this.dataTypeName)) {
            return DataHelper.getByte(this.index, target);
        }
        if (DataTypeHelper.isTime(this.dataTypeName)) {
            return (short)DataHelper.getTime(this.index, target);
        }
        return 0;
    }
}

