/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax;

import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.SettableByIndexData;
import java.lang.reflect.Method;
import java.util.Date;
import org.simpleflatmapper.datastax.DataTypeHelper;

public class DataHelper {
    private static final Method setTimestampMethod = DataHelper.getSetTimestampMethod();
    private static final Method getTimestampMethod = DataHelper.getGetTimestampMethod();
    private static final Method setTimeMethod = DataHelper.getSetTimeMethod();
    private static final Method getTimeMethod = DataHelper.getGetTimeMethod();
    private static final Method setDateMethod = DataHelper.getSetDateMethod();
    private static final Method getDateMethod = DataHelper.getGetDateMethod();
    private static final Method setSmallIntMethod = DataHelper.getSetSmallIntMethod();
    private static final Method getSmallIntMethod = DataHelper.getGetSmallIntMethod();
    private static final Method setTinyIntMethod = DataHelper.getSetTinyIntMethod();
    private static final Method getTinyIntMethod = DataHelper.getGetTinyIntMethod();

    private static Method getGetTinyIntMethod() {
        try {
            return GettableByIndexData.class.getMethod("getByte", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getSetTinyIntMethod() {
        try {
            return SettableByIndexData.class.getMethod("setByte", Integer.TYPE, Byte.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getGetSmallIntMethod() {
        try {
            return GettableByIndexData.class.getMethod("getShort", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getSetSmallIntMethod() {
        try {
            return SettableByIndexData.class.getMethod("setShort", Integer.TYPE, Short.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getGetDateMethod() {
        try {
            return GettableByIndexData.class.getMethod("getDate", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getSetDateMethod() {
        if (DataTypeHelper.localDateClass == null) {
            return null;
        }
        try {
            return SettableByIndexData.class.getMethod("setDate", Integer.TYPE, DataTypeHelper.localDateClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getGetTimeMethod() {
        try {
            return GettableByIndexData.class.getMethod("getTime", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getSetTimeMethod() {
        try {
            return SettableByIndexData.class.getMethod("setTime", Integer.TYPE, Long.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Method getGetTimestampMethod() {
        try {
            return GettableByIndexData.class.getMethod("getTimestamp", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            try {
                return GettableByIndexData.class.getMethod("getDate", Integer.TYPE);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalStateException("Unable to lookup getDate or getTimestamp on " + GettableByIndexData.class);
            }
        }
    }

    private static Method getSetTimestampMethod() {
        try {
            return SettableByIndexData.class.getMethod("setTimestamp", Integer.TYPE, Date.class);
        }
        catch (NoSuchMethodException e) {
            try {
                return SettableByIndexData.class.getMethod("setDate", Integer.TYPE, Date.class);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalStateException("Unable to lookup setDate or setTimestamp on " + SettableByIndexData.class);
            }
        }
    }

    public static void setTimestamp(int index, Date date, SettableByIndexData data) throws Exception {
        setTimestampMethod.invoke((Object)data, index, date);
    }

    public static Date getTimestamp(int index, GettableByIndexData data) throws Exception {
        return (Date)getTimestampMethod.invoke((Object)data, index);
    }

    public static void setTime(int index, long time, SettableByIndexData data) throws Exception {
        if (setTimeMethod == null) {
            throw new UnsupportedOperationException();
        }
        setTimeMethod.invoke((Object)data, index, time);
    }

    public static long getTime(int index, GettableByIndexData data) throws Exception {
        if (getTimeMethod == null) {
            throw new UnsupportedOperationException();
        }
        return (Long)getTimeMethod.invoke((Object)data, index);
    }

    public static void setDate(int index, Object localDate, SettableByIndexData data) throws Exception {
        if (setDateMethod == null) {
            throw new UnsupportedOperationException();
        }
        setDateMethod.invoke((Object)data, index, localDate);
    }

    public static Object getDate(int index, GettableByIndexData data) throws Exception {
        if (getDateMethod == null) {
            throw new UnsupportedOperationException();
        }
        return getDateMethod.invoke((Object)data, index);
    }

    public static void setShort(int index, short s, SettableByIndexData data) throws Exception {
        if (setSmallIntMethod == null) {
            throw new UnsupportedOperationException();
        }
        setSmallIntMethod.invoke((Object)data, index, s);
    }

    public static short getShort(int index, GettableByIndexData data) throws Exception {
        if (getSmallIntMethod == null) {
            throw new UnsupportedOperationException();
        }
        return (Short)getSmallIntMethod.invoke((Object)data, index);
    }

    public static void setByte(int index, byte b, SettableByIndexData data) throws Exception {
        if (setTinyIntMethod == null) {
            throw new UnsupportedOperationException();
        }
        setTinyIntMethod.invoke((Object)data, index, b);
    }

    public static byte getByte(int index, GettableByIndexData data) throws Exception {
        if (getTinyIntMethod == null) {
            throw new UnsupportedOperationException();
        }
        return (Byte)getTinyIntMethod.invoke((Object)data, index);
    }

    public static boolean hasShortAccessor() {
        return getSmallIntMethod != null;
    }

    public static boolean hasByteAccessor() {
        return getTinyIntMethod != null;
    }
}

