/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.ConnectedCrud;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.TransactionTemplate;
import org.simpleflatmapper.jdbc.impl.DataSourceTransactionTemplate;
import org.simpleflatmapper.jdbc.test.CrudTest;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;

public class ConnectedCrudTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbObjectCrud() throws Exception {
        DataSource dataSource = DbHelper.getHsqlDataSource();
        ConnectedCrud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(dataSource, "TEST_DB_OBJECT");
        this.checkCrudDbObject(objectCrud, DbObject.newInstance());
        try (Connection connection = dataSource.getConnection();){
            CrudTest.checkCrudDbObject(connection, objectCrud.crud(), DbObject.newInstance());
        }
    }

    @Test
    public void testDelegateSuccess() throws SQLException {
        Crud crud = (Crud)Mockito.mock(Crud.class);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
        ConnectedCrud connectedCrud = new ConnectedCrud((TransactionTemplate)new DataSourceTransactionTemplate(dataSource), crud);
        ArrayList values = new ArrayList();
        Object value = new Object();
        CheckedConsumer consumer = new CheckedConsumer(){

            public void accept(Object o) throws Exception {
            }
        };
        connectedCrud.create(values);
        ((Crud)Mockito.verify((Object)crud)).create(connection, values);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.create(value);
        ((Crud)Mockito.verify((Object)crud)).create(connection, value);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.create(values, consumer);
        ((Crud)Mockito.verify((Object)crud)).create(connection, values, consumer);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.create(value, consumer);
        ((Crud)Mockito.verify((Object)crud)).create(connection, value, consumer);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.read(value);
        ((Crud)Mockito.verify((Object)crud)).read(connection, value);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.read(values, consumer);
        ((Crud)Mockito.verify((Object)crud)).read(connection, values, consumer);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.update(value);
        ((Crud)Mockito.verify((Object)crud)).update(connection, value);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.update(values);
        ((Crud)Mockito.verify((Object)crud)).update(connection, values);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.delete(value);
        ((Crud)Mockito.verify((Object)crud)).delete(connection, value);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.delete(values);
        ((Crud)Mockito.verify((Object)crud)).delete(connection, values);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.createOrUpdate(value);
        ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, value);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.createOrUpdate(values);
        ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, values);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.createOrUpdate(value, consumer);
        ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, value, consumer);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
        connectedCrud.createOrUpdate(values, consumer);
        ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, values, consumer);
        this.verifyCloseCommitAndReset((Crud<Object, Object>)crud, connection);
    }

    @Test
    public void testDelegateFail() throws SQLException {
        Crud crud = (Crud)Mockito.mock(Crud.class);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
        ConnectedCrud connectedCrud = new ConnectedCrud((TransactionTemplate)new DataSourceTransactionTemplate(dataSource), crud);
        ArrayList values = new ArrayList();
        Object value = new Object();
        CheckedConsumer consumer = new CheckedConsumer(){

            public void accept(Object o) throws Exception {
            }
        };
        RuntimeException exception = new RuntimeException();
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)connection)).commit();
        try {
            connectedCrud.create(values);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).create(connection, values);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.create(value);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).create(connection, value);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.create(values, consumer);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).create(connection, values, consumer);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.create(value, consumer);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).create(connection, value, consumer);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.read(value);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).read(connection, value);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.read(values, consumer);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).read(connection, values, consumer);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.update(value);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).update(connection, value);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.update(values);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).update(connection, values);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.delete(value);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).delete(connection, value);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.delete(values);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).delete(connection, values);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.createOrUpdate(value);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, value);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.createOrUpdate(values);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, values);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.createOrUpdate(value, consumer);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, value, consumer);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
        try {
            connectedCrud.createOrUpdate(values, consumer);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)exception, (Object)e);
            ((Crud)Mockito.verify((Object)crud)).createOrUpdate(connection, values, consumer);
            this.verifyCloseCommitFailAndReset(exception, (Crud<Object, Object>)crud, connection);
        }
    }

    private void verifyCloseCommitAndReset(Crud<Object, Object> crud, Connection connection) throws SQLException {
        ((Connection)Mockito.verify((Object)connection)).commit();
        ((Connection)Mockito.verify((Object)connection)).close();
        Mockito.reset((Object[])new Object[]{crud, connection});
    }

    private void verifyCloseCommitFailAndReset(Exception exception, Crud<Object, Object> crud, Connection connection) throws SQLException {
        ((Connection)Mockito.verify((Object)connection)).commit();
        ((Connection)Mockito.verify((Object)connection)).rollback();
        ((Connection)Mockito.verify((Object)connection)).close();
        Mockito.reset((Object[])new Object[]{crud, connection});
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)connection)).commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbObjectCrudTable() throws Exception {
        DataSource dataSource = DbHelper.getHsqlDataSource();
        ConnectedCrud objectCrud = JdbcMapperFactory.newInstance().crud(CrudTest.DbObjectTable.class, Long.class).to(dataSource);
        this.checkCrudDbObject(objectCrud, (CrudTest.DbObjectTable)DbObject.newInstance((DbObject)new CrudTest.DbObjectTable()));
        try (Connection connection = dataSource.getConnection();){
            CrudTest.checkCrudDbObject(connection, objectCrud.crud(), (CrudTest.DbObjectTable)DbObject.newInstance((DbObject)new CrudTest.DbObjectTable()));
        }
    }

    private <T extends DbObject> void checkCrudDbObject(ConnectedCrud<T, Long> objectCrud, T object) throws SQLException {
        Assert.assertNull((Object)objectCrud.read((Object)object.getId()));
        Long key = (objectCrud.create(object, (CheckedConsumer)new CheckedConsumer<Long>(){
            Long key;

            public void accept(Long aLong) throws Exception {
                this.key = aLong;
            }
        })).key;
        Assert.assertNull((Object)key);
        key = object.getId();
        Assert.assertEquals(object, (Object)objectCrud.read((Object)key));
        object.setName("Udpdated");
        objectCrud.update(object);
        Assert.assertEquals(object, (Object)objectCrud.read((Object)key));
        objectCrud.delete((Object)key);
        Assert.assertNull((Object)objectCrud.read((Object)key));
        objectCrud.create(object);
        Assert.assertEquals(object, (Object)objectCrud.where("id = :id", Long.class).readFirst((Object)object.getId()));
        Assert.assertEquals(Arrays.asList(object), (Object)((ListCollector)objectCrud.where("name = :name and id = :id", DbObject.class).read(object, (CheckedConsumer)new ListCollector())).getList());
    }
}

