/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.util.TypeReference;

public class Issue486Test {
    @Test
    public void noTestJava7() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssue() throws SQLException {
        JdbcMapperBuilder builder = JdbcMapperFactory.newInstance().newBuilder(new TypeReference<Issue486>(){}.getType());
        JdbcMapper mapper = (JdbcMapper)builder.addMapping("t", 1, 93).mapper();
        Connection dbConnection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (dbConnection == null) {
            return;
        }
        try {
            ResultSet rs = dbConnection.createStatement().executeQuery("SELECT CURRENT_TIMESTAMP");
            rs.next();
            Issue486 issue486 = (Issue486)mapper.map(rs);
            System.out.println("issue486 = " + issue486.t.get());
        }
        finally {
            dbConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMIssue() throws SQLException {
        JdbcMapperBuilder builder = JdbcMapperFactory.newInstance().newBuilder(new TypeReference<NIssue486>(){}.getType());
        JdbcMapper mapper = (JdbcMapper)builder.addMapping("t", 1, 93).mapper();
        Connection dbConnection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (dbConnection == null) {
            return;
        }
        try {
            ResultSet rs = dbConnection.createStatement().executeQuery("SELECT CURRENT_TIMESTAMP");
            rs.next();
            NIssue486 issue486 = (NIssue486)mapper.map(rs);
            System.out.println("issue486 = " + issue486.t);
        }
        finally {
            dbConnection.close();
        }
    }

    public static class NIssue486 {
        private Instant t;
        private UUID id;

        public Instant getT() {
            return this.t;
        }

        public void setT(Instant t) {
            this.t = t;
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }
    }

    public static class Issue486 {
        private Optional<Instant> t;
        private UUID id;

        public Optional<Instant> getT() {
            return this.t;
        }

        public void setT(Optional<Instant> t) {
            this.t = t;
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }
    }
}

