/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.map.property.KeyProperty;
import org.simpleflatmapper.test.jdbc.DbHelper;

public class Issue569Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMysqlView() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.MYSQL);
        if (connection == null) {
            System.err.println("Db " + DbHelper.TargetDB.MYSQL + " not available");
            return;
        }
        try {
            Statement st = connection.createStatement();
            st.executeUpdate("CREATE TABLE IF NOT EXISTS issue569( id bigint primary key, name varchar(256), version int ) ");
            try {
                st.executeUpdate("DROP VIEW issue569_v");
            }
            catch (Exception exception) {
                // empty catch block
            }
            st.executeUpdate("CREATE OR REPLACE  VIEW issue569_v(id, name, nb) as SELECT id, name, count(*) as nb FROM issue569 group by id, name");
            st.executeUpdate("TRUNCATE issue569");
            st.executeUpdate("INSERT INTO issue569 VALUES(1, 'v1', 1), (2, 'v2', 2)");
            Crud objectCrud = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("id", new Object[]{KeyProperty.DEFAULT})).crud(MyPojo.class, Long.class).table("issue569_v");
            Assert.assertEquals((Object)new MyPojo(1L, "v1", 1), (Object)objectCrud.read(connection, (Object)1L));
            Assert.assertEquals((Object)new MyPojo(2L, "v2", 1), (Object)objectCrud.read(connection, (Object)2L));
        }
        finally {
            connection.close();
        }
    }

    public static class MyPojo {
        private final long id;
        private final String name;
        private final int nb;

        public MyPojo(long id, String name, int nb) {
            this.id = id;
            this.name = name;
            this.nb = nb;
        }

        public int getNb() {
            return this.nb;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            if (this.id != myPojo.id) {
                return false;
            }
            return this.name != null ? this.name.equals(myPojo.name) : myPojo.name == null;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

