/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.map.annotation.Key;

public class Issue626Test {
    @Test
    public void test() {
        StringBuilder sql = new StringBuilder("SELECT products.product_id as id, product_name as name,");
        sql.append("products.product_description as description,");
        sql.append("product_price_price as price, photo_id, photo_url as product_photo_url from products");
        sql.append("INNER JOIN product_prices on products.product_id = product_prices.product_id");
        sql.append("LEFT JOIN (photos INNER JOIN product_photos on photos.photo_id = product_photos.product_photos_photo_id)");
        sql.append("ON products.product_id = product_photos.product_photos_product_id WHERE product_prices.state_id =? ORDER BY products.product_id");
        JdbcMapperBuilder builder = JdbcMapperFactory.newInstance().newBuilder(Product.class);
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)builder.addMapping("id")).addMapping("name")).addMapping("description")).addMapping("price")).addMapping("photos_id")).addMapping("photos_url")).mapper();
    }

    public class Photo {
        @Key
        private Long id;
        private String name;
        private String description;
        private String url;
        private LocalDate created;
        private LocalDate updated;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public LocalDate getCreated() {
            return this.created;
        }

        public void setCreated(LocalDate created) {
            this.created = created;
        }

        public LocalDate getUpdated() {
            return this.updated;
        }

        public void setUpdated(LocalDate updated) {
            this.updated = updated;
        }
    }

    public class Product {
        @Key
        private Long id;
        private String name;
        private String description;
        private BigDecimal price;
        private boolean promotion;
        private LocalDate created;
        private LocalDate updated;
        private boolean status;
        private Collection<Photo> photos;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public boolean isPromotion() {
            return this.promotion;
        }

        public void setPromotion(boolean promotion) {
            this.promotion = promotion;
        }

        public LocalDate getCreated() {
            return this.created;
        }

        public void setCreated(LocalDate created) {
            this.created = created;
        }

        public LocalDate getUpdated() {
            return this.updated;
        }

        public void setUpdated(LocalDate updated) {
            this.updated = updated;
        }

        public boolean isStatus() {
            return this.status;
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public Collection<Photo> getPhotos() {
            return this.photos;
        }

        public void setPhotos(Collection<Photo> photos) {
            this.photos = photos;
        }
    }
}

