/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.property.IndexedSetterProperty;
import org.simpleflatmapper.test.jdbc.DbHelper;

public class Issue649Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInetAddress() throws SQLException, UnknownHostException {
        Connection c = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (c == null) {
            return;
        }
        try {
            Statement s = c.createStatement();
            s.execute("DROP TABLE IF EXISTS issue_649;");
            s.execute("CREATE TABLE issue_649(a bigserial primary key,b inet);");
            Crud crud = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("b", new Object[]{IndexedSetterProperty.of((ps, i, t) -> ps.setObject(i, (Object)t.getHostAddress(), 1111))})).crud(FooInet.class, Long.TYPE).table(c, "issue_649");
            InetAddress inetAddress = InetAddress.getByName("192.168.0.1");
            crud.create(c, (Object)new FooInet(1L, inetAddress));
            FooInet foo = (FooInet)crud.read(c, (Object)1L);
            Assert.assertEquals((long)1L, (long)foo.a);
            Assert.assertEquals((Object)inetAddress, (Object)foo.b);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testString() throws SQLException, UnknownHostException {
        Connection c = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (c == null) {
            return;
        }
        try {
            Statement s = c.createStatement();
            s.execute("DROP TABLE IF EXISTS issue_649;");
            s.execute("CREATE TABLE issue_649(a bigserial primary key,b inet);");
            Crud crud = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("b", new Object[]{new IndexedSetterProperty((ps, t, i) -> ps.setObject(i, t, 1111))})).crud(FooString.class, Long.TYPE).table(c, "issue_649");
            String inetAddress = "192.168.0.1";
            crud.create(c, (Object)new FooString(1L, inetAddress));
            FooString foo = (FooString)crud.read(c, (Object)1L);
            Assert.assertEquals((long)1L, (long)foo.a);
            Assert.assertEquals((Object)inetAddress, (Object)foo.b);
        }
        finally {
            c.close();
        }
    }

    public static class FooString {
        public final long a;
        public final String b;

        public FooString(long a, String b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class FooInet {
        public final long a;
        public final InetAddress b;

        public FooInet(long a, InetAddress b) {
            this.a = a;
            this.b = b;
        }
    }
}

