/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.CaseInsensitiveEndsWithPredicate;
import org.simpleflatmapper.map.mapper.AbstractMapperFactory;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ListCollector;
import org.simpleflatmapper.util.Predicate;

public class Issue661_2_discriminator_same_class {
    @Test
    public void test2AssFieldWithSameTypeDiscriminatorNoAsmDSL() throws Exception {
        DynamicJdbcMapper mapper = ((JdbcMapperFactory)((JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"id", "pFirst_id", "pSecond_id"})).discriminator(Parent.class).onColumn((Predicate)CaseInsensitiveEndsWithPredicate.of((String)"class_id"), Integer.class).with((Consumer)new Consumer<AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Parent>>(){

            public void accept(AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Parent> builder) {
                builder.when((Object)1, Parent.class).when((Object)2, ChildA.class).when((Object)3, ChildB.class);
            }
        })).newMapper(Foo.class);
        this.validateMapper((JdbcMapper<Foo>)mapper);
    }

    @Test
    public void test2AssFieldWithSameTypeDiscriminatorNoAsm() throws Exception {
        DynamicJdbcMapper mapper = ((JdbcMapperFactory)((JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"id", "pFirst_id", "pSecond_id"})).discriminator(Parent.class).onColumn((Predicate)CaseInsensitiveEndsWithPredicate.of((String)"class_id"), Integer.class).with((Consumer)new Consumer<AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Parent>>(){

            public void accept(AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Parent> builder) {
                builder.when((Object)1, Parent.class).when((Object)2, ChildA.class).when((Object)3, ChildB.class);
            }
        })).newMapper(Foo.class);
        this.validateMapper((JdbcMapper<Foo>)mapper);
    }

    @Test
    public void test2AssFieldWithSameTypeWithDifferentColumnAndDifferentType() throws Exception {
        DynamicJdbcMapper mapper = ((JdbcMapperFactory)((JdbcMapperFactory)((JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"id", "pFirst_id", "pSecond_id"})).discriminator(Parent.class, "pFirst_class_id", Integer.class, (Consumer)new Consumer<AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object>>(){

            public void accept(AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object> builder) {
                builder.when((Object)1, Parent.class).when((Object)2, ChildA.class).when((Object)3, ChildB.class);
            }
        })).discriminator(Parent.class, "pSecond_class_id", Integer.class, (Consumer)new Consumer<AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object>>(){

            public void accept(AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object> builder) {
                builder.when((Object)1, Parent.class).when((Object)2, ChildC.class).when((Object)3, ChildD.class);
            }
        })).newMapper(Foo.class);
        this.validateMapper2((JdbcMapper<Foo>)mapper);
    }

    private void validateMapper(JdbcMapper<Foo> mapper) throws Exception {
        List is = ((ListCollector)mapper.forEach(this.setUpResultSetMock(), (CheckedConsumer)new ListCollector())).getList();
        Assert.assertTrue((boolean)(((Foo)is.get((int)0)).pFirst instanceof ChildA));
        Assert.assertTrue((boolean)(((Foo)is.get((int)0)).pSecond instanceof ChildB));
        Assert.assertTrue((boolean)(((Foo)is.get((int)1)).pFirst instanceof ChildA));
        Assert.assertTrue((boolean)(((Foo)is.get((int)1)).pSecond instanceof Parent));
    }

    private void validateMapper2(JdbcMapper<Foo> mapper) throws Exception {
        List is = ((ListCollector)mapper.forEach(this.setUpResultSetMock(), (CheckedConsumer)new ListCollector())).getList();
        Assert.assertTrue((boolean)(((Foo)is.get((int)0)).pFirst instanceof ChildC));
        Assert.assertTrue((boolean)(((Foo)is.get((int)0)).pSecond instanceof ChildD));
        Assert.assertTrue((boolean)(((Foo)is.get((int)1)).pFirst instanceof ChildC));
        Assert.assertTrue((boolean)(((Foo)is.get((int)1)).pSecond instanceof Parent));
    }

    private ResultSet setUpResultSetMock() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        final String[] columns = new String[]{"id", "pFirst_id", "pFirst_class_id", "pFirst_a_string", "pFirst_b_string", "pSecond_id", "pSecond_class_id", "pSecond_a_string", "pSecond_b_string"};
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)columns.length);
        Mockito.when((Object)metaData.getColumnLabel(ArgumentMatchers.anyInt())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return columns[-1 + (Integer)invocationOnMock.getArguments()[0]];
            }
        });
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)metaData);
        final AtomicInteger ai = new AtomicInteger();
        final Object[][] rows = new Object[][]{{1, 1, 2, "aString", null, 2, 3, null, "bString"}, {2, 1, 2, "aString", null, 3, 1, null, null}};
        Mockito.when((Object)rs.next()).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ai.getAndIncrement() < rows.length;
            }
        });
        Answer<Object> getValue = new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] row = rows[ai.get() - 1];
                Integer col = -1 + (Integer)invocationOnMock.getArguments()[0];
                return row[col];
            }
        };
        Answer<Object> getColumnValue = new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] row = rows[ai.get() - 1];
                String col = (String)invocationOnMock.getArguments()[0];
                return row[Arrays.asList(columns).indexOf(col)];
            }
        };
        Mockito.when((Object)rs.getInt(ArgumentMatchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getString(ArgumentMatchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getString((String)ArgumentMatchers.any(String.class))).then((Answer)getColumnValue);
        Mockito.when((Object)rs.getObject(ArgumentMatchers.anyInt())).then((Answer)getValue);
        Mockito.when(rs.getObject(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(Class.class))).then((Answer)getColumnValue);
        return rs;
    }

    @Test
    public void test2AddFieldWithSameTypeWithDifferentColumnAndDifferentTypeBuilder() throws Exception {
        JdbcMapperBuilder builder = ((JdbcMapperFactory)((JdbcMapperFactory)((JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"id", "pFirst_id", "pSecond_id"})).discriminator(Parent.class, "pFirst_class_id", Integer.class, (Consumer)new Consumer<AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object>>(){

            public void accept(AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object> builder) {
                builder.when((Object)1, Parent.class).when((Object)2, ChildA.class).when((Object)3, ChildB.class);
            }
        })).discriminator(Parent.class, "pSecond_class_id", Integer.class, (Consumer)new Consumer<AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object>>(){

            public void accept(AbstractMapperFactory.DiscriminatorConditionBuilder<ResultSet, JdbcColumnKey, Integer, Object> builder) {
                builder.when((Object)1, Parent.class).when((Object)2, ChildC.class).when((Object)3, ChildD.class);
            }
        })).newBuilder(Foo.class);
        builder.addMapping("id");
        builder.addMapping("pFirst_class_id");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
    }

    public class Foo {
        int id;
        Parent pFirst;
        Parent pSecond;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public Parent getpFirst() {
            return this.pFirst;
        }

        public void setpFirst(Parent pFirst) {
            this.pFirst = pFirst;
        }

        public Parent getpSecond() {
            return this.pSecond;
        }

        public void setpSecond(Parent pSecond) {
            this.pSecond = pSecond;
        }
    }

    public class ChildD
    extends Parent {
        String bString;

        public String getbString() {
            return this.bString;
        }

        public void setbString(String bString) {
            this.bString = bString;
        }
    }

    public class ChildC
    extends Parent {
        String aString;

        public String getaString() {
            return this.aString;
        }

        public void setaString(String aString) {
            this.aString = aString;
        }
    }

    public class ChildB
    extends Parent {
        String bString;

        public String getbString() {
            return this.bString;
        }

        public void setbString(String bString) {
            this.bString = bString;
        }
    }

    public class ChildA
    extends Parent {
        String aString;

        public String getaString() {
            return this.aString;
        }

        public void setaString(String aString) {
            this.aString = aString;
        }
    }

    public class Parent {
        int id;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

