/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.property.JdbcGetterFactoryProperty;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.util.ConstantPredicate;
import org.simpleflatmapper.util.Predicate;

public class JdbcEnumTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mapCustomEmum() throws SQLException {
        Connection conn = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (conn == null) {
            return;
        }
        try {
            DynamicJdbcMapper mapper = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty((Predicate)ConstantPredicate.truePredicate(), new Object[]{JdbcGetterFactoryProperty.forType(TypeEnum.class, (JdbcGetterFactoryProperty.ResultSetGetter)new JdbcGetterFactoryProperty.ResultSetGetter<TypeEnum>(){

                public TypeEnum get(ResultSet rs, int index) throws SQLException {
                    return TypeEnum.of(rs.getInt(index));
                }
            })})).newMapper(EventLog.class);
            try (Statement st = conn.createStatement();){
                ResultSet rs = st.executeQuery("select 1 as id, 8 as type");
                rs.next();
                EventLog eventLog = (EventLog)mapper.map(rs);
                Assert.assertEquals((long)1L, (long)eventLog.id);
                Assert.assertEquals((Object)((Object)TypeEnum.DATA_NOT_FOUND), (Object)((Object)eventLog.type));
            }
        }
        finally {
            conn.close();
        }
    }

    public static class EventLog {
        private long id;
        private TypeEnum type;

        public EventLog(TypeEnum type) {
            this.type = type;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public TypeEnum getType() {
            return this.type;
        }
    }

    public static enum TypeEnum {
        INFO(0),
        INVALID_API_ARGUMENT(7),
        DATA_NOT_FOUND(8),
        ERROR(9);

        int typeCode;

        private TypeEnum(int typeCode) {
            this.typeCode = typeCode;
        }

        public int getTypeCode() {
            return this.typeCode;
        }

        public static TypeEnum of(int i) {
            switch (i) {
                case 0: {
                    return INFO;
                }
                case 7: {
                    return INVALID_API_ARGUMENT;
                }
                case 8: {
                    return DATA_NOT_FOUND;
                }
                case 9: {
                    return ERROR;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

